/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.lang.StringUtils;

public class LogMethodNameHandler
extends BasicHandler {
    private static PogoLogger log = PogoLogger.getLogger();

    public LogMethodNameHandler() {
        this(log);
    }

    LogMethodNameHandler(PogoLogger log) {
        super(log.getNativeLogger());
        LogMethodNameHandler.log = log;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (log.isDebugEnabled()) {
            this.logRequest(mc);
        }
        this.updatePerformanceIndicator(mc);
    }

    private void logRequest(MessageContext mc) {
        this.logSoapAction(mc);
        this.logMethodName(mc);
    }

    private void logSoapAction(MessageContext mc) {
        String soapAction = (String)mc.getProperty("request.soapaction");
        if (soapAction != null) {
            log.debug("rxed request - soapaction=\"", soapAction, "\" ");
        }
    }

    private void logMethodName(MessageContext mc) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (request != null) {
            this.logMethodName(request);
        }
    }

    private void logMethodName(BIBusEnvelope request) {
        String methodName = request.getBodyHandler().getMethodName();
        if (StringUtils.isNotEmpty((String)methodName)) {
            log.debug("BIBus method: ", methodName);
        } else {
            log.debug("BIBus method name unknown, probably not a pure BIBus request.");
        }
    }

    private void updatePerformanceIndicator(MessageContext mc) {
        PerformanceEventListener pi = this.getPerformanceIndicator();
        if (pi.isEnabled()) {
            this.updateObjectPathWithMethodName(pi, mc);
        }
    }

    private void updateObjectPathWithMethodName(PerformanceEventListener pi, MessageContext mc) {
        String methodName = this.getMethodName(mc);
        if (StringUtils.isNotEmpty((String)methodName)) {
            pi.handleObjectPath(methodName);
        }
    }

    private String getMethodName(MessageContext mc) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        return request != null ? request.getBodyHandler().getMethodName() : null;
    }
}

