/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.p2plb.clerver.LoadBalanceHandler;
import com.cognos.pogo.bibus.SOAPAction;
import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PinnedRequestHandler
extends UtilHandlerBase {
    static final PogoLogger cat = PogoLogger.getLogger();
    private LoadBalanceHandler lbh;

    public PinnedRequestHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String soapAction = (String)mc.getProperty("request.soapaction");
        SOAPAction sa = new SOAPAction(soapAction);
        if (sa.getSuffix() != null && sa.getSuffix().length() > 0) {
            cat.debug("nothing to do because the request is affine.");
            return;
        }
        String serviceName = this.lbh.lookupServiceName(sa);
        if (serviceName == null) {
            cat.debug("SOAPAction ", sa, " is not load balanced, do nothing.");
            return;
        }
        Map<String, String> map = this.buildPinnedServiceMap(mc);
        if (map == null) {
            cat.debug("no services are pinned.");
            return;
        }
        String pinnedDisp = map.get(serviceName);
        if (pinnedDisp == null || pinnedDisp.length() == 0) {
            cat.debug("no pinned dispatcher for service: ", serviceName);
            return;
        }
        cat.debug("pinning request for ", serviceName, " to ", pinnedDisp);
        mc.setProperty("request.soapaction", soapAction + ".server");
        BIBusEnvelope request_env = (BIBusEnvelope)mc.getProperty("request.envelope");
        request_env.setConversationContextNodeID(pinnedDisp);
    }

    private Map<String, String> buildPinnedServiceMap(MessageContext mc) {
        try {
            BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
            String scookie = env.getCookieValue("disp_pin");
            if (scookie != null) {
                cat.debug("received disp_pin cookie with value: ", scookie);
                scookie = URLDecoder.decode(scookie, "UTF-8");
                cat.debug("disp_pin cookie decoded value: ", scookie);
                HashMap<String, String> map = new HashMap<String, String>();
                StringTokenizer st = new StringTokenizer(scookie, ";");
                while (st.hasMoreTokens()) {
                    String cv = st.nextToken();
                    StringTokenizer stc = new StringTokenizer(cv, "=");
                    String name = stc.nextToken();
                    String value = stc.nextToken();
                    if (value == null || value.length() == 0) continue;
                    if ("ps".equals(name)) {
                        map.put("presentationService", value);
                        cat.debug("ps requests pinned to: ", value);
                        continue;
                    }
                    if ("rs".equals(name)) {
                        map.put("reportService", value);
                        cat.debug("rs requests pinned to: ", value);
                        continue;
                    }
                    if ("brs".equals(name)) {
                        map.put("batchReportService", value);
                        cat.debug("brs requests pinned to: ", value);
                        continue;
                    }
                    if (!"sds".equals(name)) continue;
                    map.put("jobAndScheduleMonitoringService", value);
                    cat.debug("sds requests pinned to: ", value);
                }
                if (map.size() > 0) {
                    return map;
                }
            }
        }
        catch (Exception ex) {
            cat.warn("error parsing disp_pin cookie value", ex);
        }
        return null;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.lbh = (LoadBalanceHandler)engine.lookupHandler("bal.lb_forwarder");
        if (this.lbh == null) {
            cat.fatalError("cannot find handler bal.lb_forwarder");
        }
    }
}

