/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.handlers.errorpage.ErrorPageGenerator;
import com.cognos.pogo.handlers.errorpage.ErrorPageInfo;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Logger;

public abstract class UtilHandlerBase
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ErrorPageGenerator errorPageGenerator;

    public UtilHandlerBase(Logger log) {
        this(log, new ErrorPageGenerator());
    }

    public UtilHandlerBase(Logger log, ErrorPageGenerator errorPageGenerator) {
        super(log);
        this.errorPageGenerator = errorPageGenerator;
    }

    public static void prepareResponse(MessageContext mc, String contentType, byte[] xmlBytes) throws IOException {
        UtilHandlerBase.prepareResponse(mc, contentType, xmlBytes, 200);
    }

    public static void prepareResponse(MessageContext mc, String contentType, String response) throws IOException {
        UtilHandlerBase.prepareResponse(mc, contentType, response.getBytes("UTF-8"), 200);
    }

    public static void prepareResponse(MessageContext mc, String contentType, byte[] xmlBytes, int statusCode) throws IOException {
        ByteArrayOutputStream baosMsg = new ByteArrayOutputStream();
        StringBuffer sb = new StringBuffer();
        sb.append("Content-Type: ").append(contentType).append("\r\n");
        sb.append("Pragma: No-cache\r\n");
        sb.append("Expires: 0\r\n");
        sb.append("Cache-Control: no-cache\r\n");
        sb.append("Content-Length: ");
        sb.append(xmlBytes.length);
        sb.append("\r\n\r\n");
        baosMsg.write(sb.toString().getBytes());
        baosMsg.write(xmlBytes);
        BIBusEnvelope resp_env = new BIBusEnvelope();
        resp_env.getBody().addElement("response");
        InternetHeaders hdrs = new InternetHeaders();
        mc.setProperty("response.headers", hdrs);
        mc.setProperty("response.envelope", resp_env);
        Vector<ByteArrayInputStream> v = new Vector<ByteArrayInputStream>(1);
        v.add(new ByteArrayInputStream(baosMsg.toByteArray()));
        mc.setProperty("response.attachments", v.iterator());
        mc.setProperty("response.boundary", "big-bad-boundary");
        mc.setProperty("response.status_code", Integer.toString(statusCode));
        mc.setProperty("response.status_msg", "OK");
        mc.respond("response");
    }

    protected void forceNotFoundPage(MessageContext mc) {
        Locale locale = (Locale)mc.getProperty("locale");
        ErrorPageInfo epInfo = new ErrorPageInfo("NOT_FOUND", locale);
        epInfo.setBasehref(mc.getStrProperty("WEB_CONTENT_ROOT"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.errorPageGenerator.generateErrorPage(baos, epInfo);
        try {
            UtilHandlerBase.prepareResponse(mc, "text/html; charset=utf-8", baos.toByteArray(), 404);
        }
        catch (IOException x) {
            log.error("Error while generating page not found error page.", x);
        }
        mc.setProperty("response.status_code", Integer.toString(404));
    }
}

