/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.transport.MethodDispatcherCacheExtractor;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.base64;

public class MethodDispatcherCacheExtractorPathinfo
extends MethodDispatcherCacheExtractor {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String hmacUserSessionID;
    private String arPartName;

    public MethodDispatcherCacheExtractorPathinfo(String pathInfo, CAMUtils cam) throws Exception {
        super(cam);
        try {
            String[] split = pathInfo.split("/", 8);
            if (split.length < 7) {
                throw new Exception("Too few parameters");
            }
            if (!split[1].equals("rc")) {
                throw new Exception("rc missing");
            }
            int colon = split[2].lastIndexOf(":");
            this.dc_dispGUID = split[2].substring(0, colon);
            this.dc_rsvpPID = split[2].substring(colon + 1);
            this.dc_web64filename = split[3];
            this.hmacUserSessionID = split[4];
            this.dc_web64fileHmac = split[5];
            if (!split[6].equals("content")) {
                throw new Exception("invalid pathinfo format");
            }
            if (split.length > 7) {
                this.arPartName = split[7];
            }
        }
        catch (Exception e) {
            log.debug("Invalid rc pathinfo", e);
            throw e;
        }
    }

    @Override
    public boolean validateURLValues(CAMUtils cam, String base64usid) throws Exception {
        return cam.verifyCryptoHMAC(this.getHmacUserSessionID(), base64usid) && cam.verifyCryptoHMAC(this.getHmacFileName(), this.getFileName());
    }

    @Override
    public String getPartName() {
        return this.arPartName;
    }

    public byte[] getHmacUserSessionID() {
        return base64.decode(1, this.hmacUserSessionID);
    }

    public String getUserSessionID() {
        return this.hmacUserSessionID;
    }
}

