/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.MethodDispatcherCacheExtractor;
import com.cognos.pogo.util.PogoLogger;

public class PrepareCacheContextHandler
extends BasicHandler {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static String[] sources = new String[]{"dc", "rc"};
    private static String[] targets = new String[]{"dc.server", "rc.get"};

    public PrepareCacheContextHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String soap_action = (String)mc.getProperty("request.soapaction");
        for (int idx = 0; idx < sources.length; ++idx) {
            String source = sources[idx];
            if (!soap_action.equals(source)) continue;
            String target = targets[idx];
            mc.setProperty("request.soapaction", target);
            cat.info("PrepareCacheContextHandler sets soap_action to: ", target);
            boolean isGet = target.equals("rc.get");
            this.process(mc, isGet);
            break;
        }
    }

    void process(MessageContext mc, boolean isGet) {
        MethodDispatcherCacheExtractor extractor;
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        try {
            extractor = MethodDispatcherCacheExtractor.getInstance(mc);
        }
        catch (Exception e) {
            cat.debug("Exception processing parameters ", e);
            return;
        }
        if (extractor == null) {
            return;
        }
        String conversationID = envelope.getConversationContextID();
        if (null == conversationID || conversationID.length() == 0) {
            this.setNodeID(envelope, extractor);
            if (isGet) {
                this.prepareGet(envelope, extractor);
            }
        }
    }

    void setNodeID(BIBusEnvelope envelope, MethodDispatcherCacheExtractor extractor) {
        String dc_dispGUID = extractor.getDispatcherId();
        if (dc_dispGUID != null) {
            envelope.setConversationContextNodeID(dc_dispGUID);
        }
    }

    protected void prepareGet(BIBusEnvelope envelope, MethodDispatcherCacheExtractor extractor) {
        envelope.setConversationContextID(envelope.getTrackingRequestContext());
        try {
            long processId = Long.parseLong(extractor.getRSVPId());
            envelope.setConversationContextProcessID((int)processId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

