/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.handlers.contentmanager.viewer.ContentDispositionCreator;
import com.cognos.pogo.handlers.dispatchercache.CacheFileDescriptor;
import com.cognos.pogo.handlers.dispatchercache.DescriptorFileReader;
import com.cognos.pogo.handlers.dispatchercache.StringHeaderBuilder;
import com.cognos.pogo.util.ContentTypeFileExtensions;

public class SessionCacheInfo {
    private String contentType;
    private String reportName;
    protected String compressionType;
    private ContentDispositionCreator.DispositionType dispositionType;
    private ContentTypeFileExtensions contentTypeFileExtensions;
    private String userAgent;
    protected final String fileName;
    private CacheFileDescriptor cacheFileDescriptor;

    SessionCacheInfo(CacheFileDescriptor cacheFileDescriptor, String fileName, ContentTypeFileExtensions contentTypeFileExtensions) {
        this.cacheFileDescriptor = cacheFileDescriptor;
        this.fileName = fileName;
        this.contentTypeFileExtensions = contentTypeFileExtensions;
        this.parseDescriptor();
    }

    private void parseDescriptor() {
        DescriptorFileReader descriptorFileReader = new DescriptorFileReader(this.fileName, this.cacheFileDescriptor);
        this.contentType = descriptorFileReader.parseContentType();
        this.reportName = descriptorFileReader.parseReportName();
        this.compressionType = descriptorFileReader.parseCompression();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getCompression() {
        return this.compressionType;
    }

    public boolean isCompressed() {
        return this.compressionType != null;
    }

    public void setContentDispositionType(ContentDispositionCreator.DispositionType dispositionType) {
        this.dispositionType = dispositionType;
    }

    public String getContentDispostion() {
        ContentDispositionCreator contentDispositionCreator = this.createContentDispositionCreator();
        return contentDispositionCreator.createContentDisposition(this.userAgent);
    }

    private ContentDispositionCreator createContentDispositionCreator() {
        ContentDispositionCreator contentDispositionCreator = new ContentDispositionCreator(this.getContentType(), this.getReportName(), this.dispositionType, this.contentTypeFileExtensions);
        return contentDispositionCreator;
    }

    public void addHeaders(StringHeaderBuilder headers) {
        ContentDispositionCreator contentDispositionCreator = this.createContentDispositionCreator();
        contentDispositionCreator.addHeadersForUserAgent(headers, this.userAgent);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    String getFilePath() {
        return this.cacheFileDescriptor.getIdentifier(this.fileName);
    }

    public long getFileSize() {
        return this.cacheFileDescriptor.getSize(this.fileName);
    }
}

