/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.contentmanager.coordinator.CMUri;
import com.cognos.pogo.handlers.engine.ServiceStatusHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ActiveServiceStatusHandler
extends ServiceStatusHandler {
    private static final String DEFAULT_ERROR_CODE = "AbortIfSuspendedHandler.serviceStopped";
    private String errorCode;
    private String currentState = "standby";

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.errorCode = config.attributeValue("errorCode");
        if (StringUtils.isEmpty((String)this.errorCode)) {
            this.errorCode = DEFAULT_ERROR_CODE;
        }
    }

    @Override
    public void resume() {
        this.sendActiveStateToDispatcher();
    }

    @Override
    public void start() {
    }

    @Override
    public void allServicesStarted() {
        this.sendActiveStateToDispatcher();
    }

    @Override
    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        this.sendActiveStateToDispatcher();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (!this.isActiveCM()) {
            mc.setFault(new Fault(this.errorCode));
        }
    }

    protected boolean isActiveCM() {
        return CMUri.isActiveCMLocal();
    }

    private void sendActiveStateToDispatcher() {
        if (this.isActiveCM()) {
            this.maybeSendStateToDispatcher("running");
        } else {
            this.maybeSendStateToDispatcher("suspended");
        }
    }

    private void maybeSendStateToDispatcher(String newState) {
        if (!this.currentState.equals(newState) && this.getRequestReporter() != null) {
            this.currentState = newState;
            this.updateServiceStatus(newState);
            this.sendStateToDispatcher(newState);
            this.propagateStatus();
        }
    }

    private void updateServiceStatus(String newState) {
        String serviceStatus = this.getServiceStatusFor(newState);
        this.getRequestReporter().setServiceStatus(serviceStatus);
    }
}

