/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.handlers.engine.PropagateStatus;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;

public class PropagateStatusLocal
extends PropagateStatus {
    private static PogoLogger log = PogoLogger.getLogger();

    public PropagateStatusLocal() {
        this.createLocalExecutor();
    }

    private void createLocalExecutor() {
        log.debug("Create local executor");
        PropagateStatus.DaemonThreadFactory threadFactory = new PropagateStatus.DaemonThreadFactory();
        executor = Executors.newSingleThreadExecutor(threadFactory);
    }

    @Override
    public void propagateStatus() {
        this.propagateLocally();
    }

    private void propagateLocally() {
        executor.execute(new LocalPropagatorRunnable());
    }

    static final class LocalPropagatorRunnable
    extends SafeThread
    implements Runnable {
        LocalPropagatorRunnable() {
        }

        @Override
        public void safeRun() {
            log.debug("Propagate status locally");
            MBeanServer server = PogoMBeanServer.getInstance().getServer();
            PropagateStatus.updateDispatcherOnServer(server, PropagateStatus.additionalServicesUpdaterObjectName);
        }
    }
}

