/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.errorpage;

import com.cognos.pogo.util.PogoLogger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.LogSystem;

public class ContextFactory {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static Map<ResourceBundle, VelocityContext> contexts = new HashMap<ResourceBundle, VelocityContext>();
    private static Object[] mutex = new Object[1];
    private static boolean initialized;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        try {
            Velocity.setProperty((String)"resource.loader", (Object)"cp");
            Velocity.setProperty((String)"cp.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
            Velocity.setProperty((String)"cp.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.setProperty((String)"cp.resource.loader.cache", (Object)"false");
            Logger velocityLogger = Hierarchy.getDefaultHierarchy().getLoggerFor(ContextFactory.class.getName() + ".velocity");
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)new MyVelocityLogger(velocityLogger));
            Velocity.init();
        }
        catch (Exception e) {
            cat.error("failed to initialize Velocity.", e);
        }
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VelocityContext getContext(Iterator<String> it_resource_name, Locale locale) {
        if (!it_resource_name.hasNext()) {
            return null;
        }
        String bundle_name = it_resource_name.next();
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(bundle_name, locale);
        }
        catch (MissingResourceException x) {
            cat.error("missing resource: " + bundle_name + " " + locale, x);
        }
        VelocityContext context = null;
        Object[] objectArray = mutex;
        synchronized (mutex) {
            context = contexts.get(bundle);
            if (context != null) {
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return context;
            }
            context = it_resource_name.hasNext() ? new VelocityContext((Context)ContextFactory.getContext(it_resource_name, locale)) : new VelocityContext();
            Enumeration<String> ekeys = bundle.getKeys();
            while (ekeys.hasMoreElements()) {
                String skey = ekeys.nextElement();
                String sval = bundle.getString(skey);
                context.put(skey, (Object)sval);
            }
            context.put("LANG", (Object)locale.getLanguage());
            contexts.put(bundle, context);
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return context;
        }
    }

    static VelocityContext getContext(String resource_name, Locale locale) {
        Vector<String> vec = new Vector<String>();
        vec.add(resource_name);
        return ContextFactory.getContext(vec.iterator(), locale);
    }

    static {
        ContextFactory.init();
    }

    public static class MyVelocityLogger
    implements LogSystem {
        private Logger logger;

        public MyVelocityLogger(Logger logger) {
            this.logger = logger;
        }

        public void logVelocityMessage(int level, String message) {
            switch (level) {
                case 2: {
                    this.logger.warn(message);
                    break;
                }
                case 1: {
                    this.logger.info(message);
                    break;
                }
                case 0: {
                    this.logger.debug(message);
                    break;
                }
                case 3: {
                    this.logger.error(message);
                    break;
                }
                default: {
                    this.logger.info(message);
                }
            }
        }
    }
}

