/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.fault;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.IOException;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class PrepareFaultResponse
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PrepareFaultResponse.class.getName());
    private String cn_response;

    public PrepareFaultResponse() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.cn_response = this.getRequiredAttribute(cat, "cn_response");
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        SOAPEnvelope fault_env = mc.getFault().generateEnvelope(requestEnvelope);
        if (cat.isDebugEnabled()) {
            cat.debug("Fault found in MessageContext:");
            try {
                cat.debug(fault_env.getAsString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String sResponseCode = "500";
        sResponseCode = (String)mc.getProperty("HTTP_Response_code");
        mc.setProperty(this.cn_response + ".status_code", sResponseCode);
        mc.setProperty(this.cn_response + ".status_msg", "Internal Server Error");
        mc.setProperty(this.cn_response + ".headers", new InternetHeaders());
        mc.setProperty(this.cn_response + ".envelope", fault_env);
    }
}

