/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.fault;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.util.Iterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class TestResponseForFaultHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(TestResponseForFaultHandler.class.getName());
    private String cn_response;
    private String cn_response_envelope;
    private String cn_response_parts;

    public TestResponseForFaultHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.cn_response = this.getRequiredAttribute(cat, "cn_response");
        this.cn_response_envelope = this.cn_response + ".envelope";
        this.cn_response_parts = this.cn_response + ".attachments";
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty(this.cn_response_envelope);
        if (env == null) {
            cat.warn("no response to test.");
            return;
        }
        if (env.getBodyFault().isPresent()) {
            cat.debug("detected fault in response");
            mc.setFault(new Fault(this.getName(), env));
            Iterator it = (Iterator)mc.getProperty(this.cn_response_parts);
            while (it != null && it.hasNext()) {
                it.next();
            }
        }
    }
}

