/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.logic;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class ChainHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ChainHandler.class.getName());
    protected ArrayList<Handler> chain = new ArrayList();

    public ChainHandler() {
        super(cat);
    }

    protected ChainHandler(Logger subclass_cat) {
        super(subclass_cat);
    }

    public ArrayList<Handler> getChain() {
        return this.chain;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        for (Handler handler : this.chain) {
            handler.invoke(mc);
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        Iterator it;
        cat.debug("Preparing: " + this.getName());
        try {
            it = this.getConfig().selectNodes("chain/handler_ref").iterator();
        }
        catch (Exception x) {
            cat.error("Jaxen/XPath problem", (Throwable)x);
            throw new PogoException("Handler config problem");
        }
        if (!it.hasNext()) {
            cat.warn("ChainHandler has no handlers!");
        }
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String name = e.attributeValue("name");
            if (name == null || name.length() == 0) {
                cat.error("no name attribute in handler_ref");
                throw new PogoException("handler_ref requires name attribute");
            }
            Handler h = engine.getHandlerPool().find(name);
            if (h == null) {
                cat.error(this.getName() + ": unknown handler: " + name);
                continue;
            }
            h.compose(engine);
            cat.debug(this.getName() + ": adding handler to chain: " + name);
            this.chain.add(h);
        }
    }
}

