/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.logic;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class DelegatingHandler
extends BasicHandler {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(DelegatingHandler.class.getName());
    private String handler_ref;
    private Handler delegate;

    public DelegatingHandler() {
        super(logger);
    }

    @Override
    public void allServicesStarted() {
        if (this.delegate != null) {
            this.delegate.allServicesStarted();
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        super.compose_impl(engine);
        this.delegate = engine.lookupHandler(this.handler_ref);
        if (this.delegate == null) {
            logger.info("in compose_impl failed to resolve handler " + this.handler_ref + " this is likely because some optional component is not installed.");
            return;
        }
        logger.debug("resolved handler_ref to: " + this.delegate.getClass().getName());
        this.delegate.contextualize(this.getConfig());
        this.delegate.compose(engine);
    }

    @Override
    public void configure(Configuration configuration) {
        if (this.delegate != null) {
            this.delegate.configure(configuration);
        }
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.handler_ref = this.getRequiredAttribute(logger, "handler_ref");
        logger.debug("value of handler_ref attribute is: " + this.handler_ref);
    }

    @Override
    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    @Override
    public void initialize() {
        if (this.delegate != null) {
            this.delegate.initialize();
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        if (this.delegate != null) {
            this.delegate.reconfigure(configuration);
        }
    }

    @Override
    public void resume() {
        if (this.delegate != null) {
            this.delegate.resume();
        }
    }

    @Override
    public void start() {
        if (this.delegate != null) {
            this.delegate.start();
        }
    }

    @Override
    public void stop() {
        if (this.delegate != null) {
            this.delegate.stop();
        }
    }

    @Override
    public void suspend() {
        if (this.delegate != null) {
            this.delegate.suspend();
        }
    }

    @Override
    public void suspend(boolean immediate) {
        if (this.delegate != null) {
            this.delegate.suspend(immediate);
        }
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.delegate != null) {
            this.delegate.invoke(mc);
        }
    }
}

