/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.systemservice;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.handlers.systemservice.GetConfiguration;
import com.cognos.pogo.handlers.systemservice.GetConfigurationV1;
import com.cognos.pogo.handlers.systemservice.GetFormatSamples;
import com.cognos.pogo.handlers.systemservice.GetFormatSamplesV1;
import com.cognos.pogo.handlers.systemservice.MapContentLocale;
import com.cognos.pogo.handlers.systemservice.MapContentLocaleV1;
import com.cognos.pogo.handlers.systemservice.MapProductLocale;
import com.cognos.pogo.handlers.systemservice.MapProductLocaleV1;
import com.cognos.pogo.handlers.systemservice.NormalizeLocale;
import com.cognos.pogo.handlers.systemservice.NormalizeLocaleV1;
import com.cognos.pogo.handlers.systemservice.SystemServiceTemplate;
import com.cognos.pogo.handlers.systemservice.ValidateContentLocale;
import com.cognos.pogo.handlers.systemservice.ValidateContentLocaleV1;
import com.cognos.pogo.handlers.systemservice.ValidateProductLocale;
import com.cognos.pogo.handlers.systemservice.ValidateProductLocaleV1;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class SystemServiceHandler
extends BasicHandler {
    private static final String SYSTEM_SERVICE_SOAPACTION = "http://developer.cognos.com/schemas/systemService/1";
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(SystemServiceHandler.class.getName());
    private Configuration configurationWrapper;
    private Map<String, SystemServiceTemplate> operationLookupMap;
    private Map<String, SystemServiceTemplate> operationLookupMapV1;
    private static final InternetHeaders nullInternetHeaders = new InternetHeaders();

    public SystemServiceHandler() {
        super(logger);
    }

    @Override
    public void configure(Configuration configuration) {
        this.configurationWrapper = configuration;
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configurationWrapper = configuration;
        ICCLConfiguration cclConfiguration = configuration.getICCLConfiguration();
        for (SystemServiceTemplate templateClass : this.operationLookupMap.values()) {
            templateClass.reconfigure(cclConfiguration);
        }
    }

    @Override
    public void initialize() {
        HashMap<String, SystemServiceTemplate> lookupMap = new HashMap<String, SystemServiceTemplate>();
        lookupMap.put("mapContentLocale", new MapContentLocale());
        lookupMap.put("mapProductLocale", new MapProductLocale());
        lookupMap.put("normalizeLocale", new NormalizeLocale());
        lookupMap.put("validateContentLocale", new ValidateContentLocale());
        lookupMap.put("validateProductLocale", new ValidateProductLocale());
        lookupMap.put("getConfiguration", new GetConfiguration());
        lookupMap.put("getFormatSamples", new GetFormatSamples());
        this.operationLookupMap = Collections.unmodifiableMap(lookupMap);
        HashMap<String, SystemServiceTemplate> lookupMapV1 = new HashMap<String, SystemServiceTemplate>();
        lookupMapV1.put("mapContentLocale", new MapContentLocaleV1());
        lookupMapV1.put("mapProductLocale", new MapProductLocaleV1());
        lookupMapV1.put("normalizeLocale", new NormalizeLocaleV1());
        lookupMapV1.put("validateContentLocale", new ValidateContentLocaleV1());
        lookupMapV1.put("validateProductLocale", new ValidateProductLocaleV1());
        lookupMapV1.put("getConfiguration", new GetConfigurationV1());
        lookupMapV1.put("getFormatSamples", new GetFormatSamplesV1());
        this.operationLookupMapV1 = Collections.unmodifiableMap(lookupMapV1);
    }

    @Override
    public void invokeImpl(MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element soapBody = envelope.getBody();
        Iterator it = soapBody.elementIterator();
        if (!it.hasNext()) {
            mc.setFault(new Fault("SystemServiceHandler.noOperation"));
        }
        Element operationElement = (Element)it.next();
        String operationName = operationElement.getName();
        String soapAction = mc.getStrProperty("request.soapaction");
        boolean v1 = soapAction.equals(SYSTEM_SERVICE_SOAPACTION);
        try {
            SystemServiceTemplate serviceOperation = v1 ? this.operationLookupMapV1.get(operationName) : this.operationLookupMap.get(operationName);
            if (serviceOperation == null) {
                mc.setFault(new Fault("SystemServiceHandler.noOperation"));
                return;
            }
            ICCLConfiguration cclConfiguration = this.configurationWrapper.getICCLConfiguration();
            SOAPEnvelope responseEnvelope = serviceOperation.performOperation(operationElement, cclConfiguration, envelope);
            envelope.copyHeaderTo(responseEnvelope);
            mc.setResponseName("response");
            mc.setProperty("response.envelope", responseEnvelope);
            mc.setProperty("response.headers", nullInternetHeaders);
            if (responseEnvelope.getBodyFault().isPresent()) {
                mc.setProperty("response.status_code", "500");
                mc.setProperty("response.status_msg", "Internal Server Error");
            } else {
                mc.setProperty("response.status_code", "200");
                mc.setProperty("response.status_msg", "OK");
            }
        }
        catch (Exception ex) {
            logger.debug("SystemService request failed", (Throwable)ex);
            mc.setFault(new Fault("SystemServiceHandler.requestFailed", ex));
        }
    }
}

