/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.tracking;

import com.cognos.pogo.bibus.SOAPAction;
import com.cognos.pogo.handlers.tracking.ConversationContextRoundTripHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.ParamBucket;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConversationContextRoundTripHandler
extends BasicHandler {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(ConversationContextRoundTripHandler.class.getName());
    public static final String FORM_VAR_NAME = "pps_tracking";

    public ConversationContextRoundTripHandler() {
        super(logger);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        ParamBucket param_bucket = (ParamBucket)mc.getProperty("request.param_bucket");
        if (param_bucket == null) {
            return;
        }
        String soapAction = mc.getStrProperty("request.soapaction");
        if (soapAction == null) {
            logger.warn("No soap action in message context.  This is unexpected.");
            return;
        }
        SOAPAction sa = new SOAPAction(soapAction);
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        this.setRoutingServerGroupFromForm(param_bucket, sa, requestEnvelope);
        if (this.isNonAffineRequest(sa)) {
            logger.debug("non affine request, tracking not required so do nothing.");
            return;
        }
        String nodeId = requestEnvelope.getConversationContextNodeID();
        if (nodeId != null && nodeId.length() > 0) {
            logger.debug("conversation context is setup already, so do nothing");
            return;
        }
        String trackingVar = param_bucket.getValue(FORM_VAR_NAME);
        if (trackingVar == null || trackingVar.length() == 0) {
            logger.debug("no tracking variable value, so do nothing.");
            return;
        }
        this.initializeConversationContext(requestEnvelope, trackingVar);
    }

    private boolean isNonAffineRequest(SOAPAction sa) {
        String affinity = sa.getSuffix();
        return affinity == null || affinity.length() == 0;
    }

    private String getFormRoutingServerGroup(ParamBucket param_bucket, SOAPAction sa, BIBusEnvelope requestEnvelope) {
        boolean bRoutingServerGroupNotSet;
        String formRoutingServerGroup = null;
        String routingServerGroup = requestEnvelope.getRoutingServerGroup();
        boolean bl = bRoutingServerGroupNotSet = routingServerGroup == null || routingServerGroup.length() == 0;
        if (bRoutingServerGroupNotSet) {
            formRoutingServerGroup = this.getFormRoutingServerGroupForService(param_bucket, sa);
        }
        return formRoutingServerGroup;
    }

    private String getFormRoutingServerGroupForService(ParamBucket param_bucket, SOAPAction sa) {
        String formRoutingServerGroup = null;
        if (this.isPowerplayServiceNonAffineRequest(sa)) {
            formRoutingServerGroup = param_bucket.getValue("ui.routingServerGroup");
            if (formRoutingServerGroup == null) {
                formRoutingServerGroup = param_bucket.getValue("ppes_routingsg");
            }
        } else if (this.isMetricStudioRequest(sa)) {
            formRoutingServerGroup = param_bucket.getValue("disp.routingServerGroup");
        }
        return formRoutingServerGroup;
    }

    private boolean isPowerplayServiceNonAffineRequest(SOAPAction sa) {
        return this.isNonAffineRequest(sa) && sa.getRoot().indexOf("powerPlayService") != -1;
    }

    private boolean isMetricStudioRequest(SOAPAction sa) {
        return sa.getRoot().startsWith("mms") || sa.getRoot().startsWith("dis");
    }

    private void setRoutingServerGroupFromForm(ParamBucket param_bucket, SOAPAction sa, BIBusEnvelope requestEnvelope) {
        String formRoutingServerGroup = this.getFormRoutingServerGroup(param_bucket, sa, requestEnvelope);
        if (formRoutingServerGroup != null) {
            this.setRoutingServerGroupInEnvelope(formRoutingServerGroup, requestEnvelope);
        }
    }

    private void setRoutingServerGroupInEnvelope(String routingServerGroup, BIBusEnvelope requestEnvelope) {
        requestEnvelope.setRoutingServerGroup(routingServerGroup);
        if (logger.isDebugEnabled()) {
            logger.debug("set routing server group: " + routingServerGroup);
        }
    }

    private void initializeConversationContext(BIBusEnvelope requestEnvelope, String trackingVar) throws PogoException {
        logger.debug("Initializing conversationContext from form variable.");
        ConversationContextRoundTripHelper ccrth = new ConversationContextRoundTripHelper();
        ccrth.parseTrackingString(trackingVar);
        requestEnvelope.setConversationContextAffinityStrength(ccrth.getAffinityStrength());
        requestEnvelope.setConversationContextID(ccrth.getId());
        requestEnvelope.setConversationContextNodeID(ccrth.getNodeId());
        requestEnvelope.setConversationContextProcessID(ccrth.getProcessId());
        requestEnvelope.setConversationContextStatus(ccrth.getStatus());
    }
}

