/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.tracking;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.base64;
import java.util.StringTokenizer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConversationContextRoundTripHelper {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(ConversationContextRoundTripHelper.class.getName());
    private int affinityStrength = 5000;
    private String id = "";
    private String nodeId = NodeID.getSelf().getGuid();
    private int processId = 1;
    private String status = "conversationComplete";

    private void reset() {
        this.affinityStrength = 5000;
        this.id = "";
        this.nodeId = NodeID.getSelf().getGuid();
        this.processId = 1;
        this.status = "conversationComplete";
    }

    public int getProcessId() {
        return this.processId;
    }

    public String getStatus() {
        return this.status;
    }

    public int getAffinityStrength() {
        return this.affinityStrength;
    }

    public String getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String createTrackingElement(int affinityStrength, String status, BIBusEnvelope reqEnv) {
        StringBuffer tracking = new StringBuffer(Integer.toString(affinityStrength));
        tracking.append(";").append(reqEnv.getConversationContextID()).append(";").append(reqEnv.getConversationContextNodeID());
        tracking.append(";").append(reqEnv.getConversationContextProcessID()).append(";").append(status);
        return tracking.toString();
    }

    public boolean parseTrackingString(String tracking) throws PogoException {
        StringTokenizer st = new StringTokenizer(tracking, ";");
        try {
            String as = st.nextToken();
            if (as != null) {
                this.affinityStrength = Integer.parseInt(as);
            }
            this.id = st.nextToken();
            this.nodeId = this.decode64(st.nextToken());
            String pi = st.nextToken();
            if (pi != null) {
                this.processId = Integer.parseInt(pi);
            }
            this.status = st.nextToken();
            return true;
        }
        catch (Exception any) {
            logger.error("malformed pp_tracking value.  pp_tracking is ignored.");
            this.reset();
            return false;
        }
    }

    private String decode64(String nodeIdToken) {
        byte[] decode = base64.decode(2, nodeIdToken);
        String decoded = new String(decode);
        return decoded;
    }
}

