/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.tracking;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieFactory;
import com.cognos.indications.LogIPFControl;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.bi.logging.glug.support.InvalidLoggingCookieException;
import com.ibm.bi.logging.glug.support.LoggingCookie;

public class SetSessionContextHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    private static final String DYE_TRACE_SESSION_CONTEXT_PREFIX = "f:";

    public SetSessionContextHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        String sessionContext = envelope.getSessionContext();
        if (log.isDebugEnabled()) {
            log.debug("sessionContext = " + sessionContext);
        }
        if (sessionContext == null || this.dyeTracingOn(sessionContext) && !this.isRequestSigned(envelope)) {
            String sessionid = this.generateSessionContext(envelope);
            if (log.isDebugEnabled()) {
                log.debug("new sessionContext = " + sessionid);
            }
            sessionContext = this.setSessionLoggingInContext(envelope, sessionid);
            if (log.isDebugEnabled()) {
                log.debug("newer sessionContext = " + sessionContext);
            }
            this.setSessionContext(envelope, sessionContext);
        }
    }

    private String setSessionLoggingInContext(BIBusEnvelope envelope, String sessionid) {
        String sessionContext = sessionid;
        try {
            LoggingCookie lcCookie = LoggingCookie.parseCookie((String)envelope.getCookieValue("ba-logging-session"));
            if (lcCookie != null && !lcCookie.isExpired()) {
                sessionContext = "f:1:" + sessionid.substring(4) + "_{_" + lcCookie.getSessionId() + "_}_";
            }
        }
        catch (InvalidLoggingCookieException invalidLoggingCookieException) {
            // empty catch block
        }
        return sessionContext;
    }

    private String generateSessionContext(BIBusEnvelope envelope) {
        String passport = this.getPassport(envelope);
        try {
            CAMCookie camCookie = CAMCookieFactory.createCAMCookie((String)passport);
            return this.generateSessionContext(camCookie.getPassportID(), envelope.getLogEnabled());
        }
        catch (Exception e) {
            log.warn("Exception thrown while generating session ID ", e);
            return passport;
        }
    }

    private String getPassport(BIBusEnvelope envelope) {
        return envelope.checkAuthenticated();
    }

    protected String generateSessionContext(String passportID, boolean logEnabled) throws Exception {
        String session = LogIPFControl.generateSessionID((String)passportID, (boolean[])new boolean[]{logEnabled});
        log.debug(session);
        return session;
    }

    private void setSessionContext(BIBusEnvelope env, String sessionContext) {
        if (log.isDebugEnabled()) {
            log.debug("Setting logging Session Context to: " + sessionContext);
        }
        env.setSessionContext(sessionContext);
        loggingRealm.getLoggingContext().setSessionID(sessionContext);
    }

    private boolean dyeTracingOn(String sessionContext) {
        return sessionContext.startsWith(DYE_TRACE_SESSION_CONTEXT_PREFIX);
    }

    protected boolean isRequestSigned(BIBusEnvelope envelope) {
        return envelope.getBiBusHeader().getCamProtect().isPresent();
    }
}

