/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.xts;

import com.cognos.pogo.handlers.xts.FormFieldModifier;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;

public class DefaultPageHandler
extends FormFieldModifier {
    private static final PogoLogger cat = PogoLogger.getLogger();
    protected String soapAction;

    public DefaultPageHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String messageSoapAction = mc.getStrProperty("request.soapaction");
        if (this.checkMessageSoapAction(messageSoapAction)) {
            return;
        }
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String transport = env.getDispatcherTransportValue("html");
        if (transport == null || !transport.equals("true")) {
            mc.setFault(new Fault("PogoServlet.noSOAPAction"));
            return;
        }
        if (this.isMisconfigured()) {
            cat.warn("can't change request to default page because misconfigured.");
            mc.setFault(new Fault("PogoServlet.noSOAPAction"));
            return;
        }
        cat.debug("changing empty request to hit default page.");
        mc.setProperty("request.soapaction", this.soapAction);
        super.invokeImpl(mc);
    }

    private boolean checkMessageSoapAction(String messageSoapAction) {
        if (messageSoapAction == null) {
            return false;
        }
        if (messageSoapAction.matches(" *")) {
            cat.warn("Soap action is blank, may be an empty request");
            return false;
        }
        return true;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        super.compose_impl(engine);
        this.soapAction = this.getRequiredAttribute(cat.getNativeLogger(), "soapAction");
    }
}

