/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.xts;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.common.FormFieldVars;
import com.cognos.pogo.util.PogoLogger;
import java.util.Iterator;
import org.dom4j.Element;

public class FormFieldModifier
extends BasicHandler {
    private final PogoLogger log;
    private Element configFormFieldVars;

    public FormFieldModifier(PogoLogger log) {
        super(log.getNativeLogger());
        this.log = log;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.configFormFieldVars = this.getConfig().element("formFieldVars");
        if (this.isMisconfigured()) {
            this.log.error("missing required configuration element: formFieldVars");
        }
    }

    protected boolean isMisconfigured() {
        return this.configFormFieldVars == null;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        this.addFormFieldVars(envelope);
    }

    private void addFormFieldVars(Envelope envelope) {
        Iterator it = this.configFormFieldVars.elementIterator();
        while (it.hasNext()) {
            this.addFormFieldVar(envelope, (Element)it.next());
        }
    }

    private void addFormFieldVar(Envelope envelope, Element var) {
        this.addFormFieldVar(envelope, var.elementText("name"), var.elementText("value"));
    }

    private void addFormFieldVar(Envelope envelope, String name, String value) {
        FormFieldVars formFieldVars = envelope.getBiBusHeader().getHdrSession().getFormFieldVars();
        this.log.debug("adding formfield var: ", name, ", ", value);
        formFieldVars.addFormField(name, value, null);
    }
}

