/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.xts;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.handlers.xts.FormFieldModifier;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.ccl4j.util.CCLEncodingMap;

public class PowerPlayDrillThruHandler
extends FormFieldModifier {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static String defaultEncoding = "UTF-8";
    private ICCLConfiguration icclConfig;
    private String soapAction;

    public PowerPlayDrillThruHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (mc.getProperty("request.soapaction") != null) {
            return;
        }
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String transport = env.getDispatcherTransportValue("html");
        if (transport == null || !transport.equals("true")) {
            return;
        }
        if (env.getFormValue("command") == null) {
            return;
        }
        if (this.isMisconfigured()) {
            cat.warn("can't change request to hit drill thru morphlet page because misconfigured.");
            mc.setFault(new Fault("PogoServlet.noSOAPAction"));
            return;
        }
        cat.debug("changing drill thru request to hit special morphlet.");
        mc.setProperty("request.soapaction", this.soapAction);
        super.invokeImpl(mc);
        String LO = env.getFormValue("LO");
        if (LO != null) {
            try {
                String mappedContentLocale = this.icclConfig.mapContentLocale(LO, true);
                cat.debug("mapped LO parameter \"", LO, "\" to content locale \"", mappedContentLocale, "\"");
                env.setFormField("lang", mappedContentLocale);
            }
            catch (CCLConfigurationException e) {
                cat.error("failed to map string " + LO + " to content locale.", e);
            }
            env.setFormField("lang", LO);
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        super.compose_impl(engine);
        this.soapAction = this.getAttribute(cat, "soapAction");
        defaultEncoding = this.getAttribute(cat, "defaultEncoding");
    }

    private static boolean hasCommandParameter(String queryString) {
        if (queryString == null) {
            return false;
        }
        if (queryString.length() < 8) {
            return false;
        }
        if (queryString.startsWith("command=")) {
            return true;
        }
        return queryString.indexOf("&command=") != -1;
    }

    private static String getEncodingValue(String sq, String name) {
        String encodingValue = defaultEncoding;
        int ienc = 0;
        ienc = sq.indexOf(name);
        if (ienc != -1) {
            String s = sq.substring(ienc + name.length());
            int iamp = s.indexOf(38);
            if (iamp != -1) {
                s = s.substring(0, iamp);
            }
            encodingValue = s;
            cat.debug("Drill through request specifies encoding: ", encodingValue);
        } else {
            encodingValue = defaultEncoding;
            cat.debug("Using configured default drill through encoding: ", encodingValue);
        }
        return encodingValue;
    }

    public static String determineEncoding(String sq) {
        if (sq == null) {
            return null;
        }
        String encoding = null;
        encoding = PowerPlayDrillThruHandler.hasCommandParameter(sq) ? PowerPlayDrillThruHandler.getEncodingValue(sq, "encoding=") : PowerPlayDrillThruHandler.getEncodingValue(sq, "m_encoding=");
        if (encoding.equalsIgnoreCase(defaultEncoding)) {
            return encoding;
        }
        String tempEncoding = encoding.toUpperCase();
        String javaEncoding = CCLEncodingMap.getIANA2JavaMapping((String)tempEncoding);
        if (null == javaEncoding) {
            cat.debug("Failed to resolve request encoding \"", encoding, "\" to a Java encoding name.");
            cat.debug("Using ", encoding, "as-is");
            return encoding;
        }
        cat.debug("Resolved request encoding to Java encoding: ", javaEncoding);
        return javaEncoding;
    }

    @Override
    public void configure(Configuration configuration) {
        this.icclConfig = configuration.getICCLConfiguration();
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.icclConfig = configuration.getICCLConfiguration();
    }
}

