/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.pogo.http.ConnectionCreator;
import com.cognos.pogo.http.ConnectionOwner;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.util.CAMUtils;
import java.util.Set;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class AbstractConnectionPool
implements ConnectionOwner {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(AbstractConnectionPool.class.getName());
    private String host;
    private int port;
    private boolean ssl;
    private int maxPoolSize;
    private boolean poolDisposed = false;
    private String tempDirectory;
    private boolean nonBlocking = false;
    private boolean disposeUponFailure = false;
    private static CAMFactory camf = null;
    protected ConnectionCreator connectionFactory;
    protected CAMUtils camUtils = new CAMUtils();

    AbstractConnectionPool(String serverHost, int serverPort, boolean serverSsl, int maximumPoolSize, String tempDir, ConnectionCreator creator) {
        this.host = serverHost;
        this.port = serverPort;
        this.ssl = serverSsl;
        this.maxPoolSize = maximumPoolSize;
        this.tempDirectory = tempDir;
        this.connectionFactory = creator;
    }

    public AbstractConnectionPool(CAMUtils camUtils) {
        this(null, 0, false, 0, null, null);
        this.camUtils = camUtils;
    }

    void setPoolDisposed(boolean poolDisposed) {
        this.poolDisposed = poolDisposed;
    }

    protected boolean isDisposed() {
        return this.poolDisposed;
    }

    int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean getSsl() {
        return this.ssl;
    }

    protected String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setNonBlocking(boolean newNonBlockingValue) {
        this.nonBlocking = newNonBlockingValue;
    }

    boolean isNonBlocking() {
        return this.nonBlocking;
    }

    @Override
    public boolean isDisposeUponFailure() {
        return this.disposeUponFailure;
    }

    public void setDisposeUponFailure(boolean b) {
        this.disposeUponFailure = b;
    }

    protected abstract Set<ServerConnection> getConnectionsView();

    protected abstract int getCurrentSize();

    protected abstract ServerConnection getConnection() throws IllegalStateException;

    @Override
    public abstract void release(ServerConnection var1);

    @Override
    public abstract void dispose();

    public void resizeConnectionPool(int newPoolSize) {
        this.maxPoolSize = newPoolSize;
    }

    protected abstract boolean isIdle();

    @Override
    public CAMFactory getCAMFactory() {
        if (camf == null) {
            try {
                camf = this.camUtils.getCamFactory();
            }
            catch (CAMCryptoException cce) {
                category.fatalError("Unable to initialize CAM Crypto", (Throwable)cce);
            }
        }
        return camf;
    }

    protected void setConnectionFactory(ConnectionCreator connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

