/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http;

import com.cognos.pogo.pdk.performance.events.HttpRequestEvent;
import com.cognos.pogo.util.CAMUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SimpleHttpConnection {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(SimpleHttpConnection.class.getName());
    private static final int RETRY_COUNT = 3;
    private static final String HTTP_CONNECTION_TIMEOUT = "http.connection.timeout";
    private static final String HTTP_SOCKET_TIMEOUT = "http.socket.timeout";
    protected HttpClient client;
    protected URL cmUrl;
    protected CAMUtils camUtils;

    public static SimpleHttpConnection getNewConnection(String activeCmUri) throws Exception {
        return SimpleHttpConnection.getNewConnection(activeCmUri, new CAMUtils());
    }

    public static SimpleHttpConnection getNewConnection(String activeCmUri, CAMUtils utils) throws Exception {
        return new SimpleHttpConnection(activeCmUri, utils);
    }

    public SimpleHttpConnection(String activeCmUri) throws Exception {
        this(activeCmUri, new CAMUtils());
    }

    public SimpleHttpConnection(String activeCmUri, CAMUtils utils) throws Exception {
        this.camUtils = utils;
        this.cmUrl = new URL(activeCmUri);
        this.client = this.camUtils.createHttpClient(this.cmUrl);
    }

    public static SimpleHttpConnection getNewConnection() {
        return new SimpleHttpConnection();
    }

    public SimpleHttpConnection() {
        this.client = new HttpClient();
    }

    public String get(String uri) {
        GetMethod method = this.getNewMethod(uri);
        return this.executeMethodWithRetry(method);
    }

    public String get() {
        GetMethod method = this.getNewMethod(this.cmUrl.getPath());
        return this.executeMethodWithRetry(method);
    }

    private String executeMethodWithRetry(GetMethod method) {
        this.configureRetryHandler(method);
        return this.executeMethod(method);
    }

    protected GetMethod getNewMethod(String uri) {
        return new GetMethod(uri);
    }

    private void configureRetryHandler(GetMethod method) {
        DefaultMethodRetryHandler retryhandler = new DefaultMethodRetryHandler();
        retryhandler.setRequestSentRetryEnabled(true);
        retryhandler.setRetryCount(3);
        method.setMethodRetryHandler((MethodRetryHandler)retryhandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeMethod(GetMethod method) {
        HttpRequestEvent perfEvent = new HttpRequestEvent((HttpMethod)method);
        try {
            if (this.isMethodExecutionSuccessful(method)) {
                String string = this.getResponse(method);
                return string;
            }
        }
        catch (Exception e) {
            cat.debug("Exception caught while accessing " + this.getURI(method), (Throwable)e);
        }
        finally {
            perfEvent.completed();
            method.releaseConnection();
        }
        return null;
    }

    private boolean isMethodExecutionSuccessful(GetMethod method) throws IOException, HttpException {
        return this.client.executeMethod((HttpMethod)method) == 200;
    }

    private String getResponse(GetMethod method) throws IOException {
        return this.getResponseFromStream(method);
    }

    private String getResponseFromStream(GetMethod method) throws IOException {
        int ch;
        InputStream inputStream = method.getResponseBodyAsStream();
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuilder builder = new StringBuilder();
        while ((ch = ((Reader)reader).read()) != -1) {
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private String getURI(GetMethod method) {
        try {
            return method.getURI().getURI();
        }
        catch (URIException e) {
            return "<no URI>";
        }
    }

    public CAMUtils getCamUtils() {
        return this.camUtils;
    }

    public void setConnectionTimeout(int timeout) {
        this.client.getParams().setIntParameter(HTTP_CONNECTION_TIMEOUT, timeout);
    }

    public int getConnectionTimeout() {
        return (Integer)this.client.getParams().getParameter(HTTP_CONNECTION_TIMEOUT);
    }

    public void setSocketTimeout(int timeout) {
        this.client.getParams().setIntParameter(HTTP_SOCKET_TIMEOUT, timeout);
    }

    public int getSocketTimeout() {
        return (Integer)this.client.getParams().getParameter(HTTP_SOCKET_TIMEOUT);
    }
}

