/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.inprocess;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class LocalConnectionStream
extends InputStream {
    private static final int EOS = -1;
    private final Iterator<InputStream> attachments;
    private final byte[] startBoundary;
    private final byte[] endBoundary;
    private State state;

    public LocalConnectionStream(Iterator<InputStream> attachments, byte[] startBoundary, byte[] endBoundary) {
        this.attachments = attachments;
        this.startBoundary = startBoundary;
        this.endBoundary = endBoundary;
        this.state = new BoundaryState(startBoundary, true);
    }

    @Override
    public int read() throws IOException {
        int b = this.state.read();
        while (b == -1 && this.state.hasNext()) {
            this.state = this.state.next();
            b = this.state.read();
        }
        return b;
    }

    private class AttachmentState
    implements State {
        private InputStream stream;

        public AttachmentState(Iterator<InputStream> attachments) {
            this.stream = attachments.next();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public State next() {
            if (LocalConnectionStream.this.attachments.hasNext()) {
                return new BoundaryState(LocalConnectionStream.this.startBoundary, true);
            }
            return new BoundaryState(LocalConnectionStream.this.endBoundary, false);
        }
    }

    private class BoundaryState
    implements State {
        private ByteArrayInputStream stream;
        private final boolean hasNext;

        public BoundaryState(byte[] boundary, boolean hasNext) {
            this.hasNext = hasNext;
            this.stream = new ByteArrayInputStream(boundary);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public State next() {
            return new AttachmentState(LocalConnectionStream.this.attachments);
        }
    }

    private static interface State {
        public int read() throws IOException;

        public boolean hasNext();

        public State next();
    }
}

