/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.inprocess;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.bibus.SOAPMessageOutputter;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.http.inprocess.ClientStream;
import com.cognos.pogo.http.inprocess.InOutStream;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.http.inprocess.LocalServletMessage;
import com.cognos.pogo.http.inprocess.ServletRequestStream;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPXMLSource;
import com.cognos.pogo.util.PogoLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;

public class LocalServletRequest
implements HttpServletRequest,
LocalServletMessage {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final LocalServerConnection localServerConnection;
    private final ClientStream clientRequestStream;
    private final ServletRequestStream servletRequestStream;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String contentType;
    private String queryString;
    private String pathInfo;
    private String method;
    private String authType;
    private String pathTranslated;
    private String serverName;
    private String contextPath;
    private String servletPath;
    private String protocol;
    private String remoteUser;
    private String remoteAddr;
    private int serverPort;
    private int contentLength;
    private boolean isChunked = true;
    private BIBusEnvelope envelope;

    public LocalServletRequest(LocalServerConnection localServerConnection) {
        this.localServerConnection = localServerConnection;
        this.clientRequestStream = new ClientStream(this);
        this.servletRequestStream = new ServletRequestStream();
    }

    public LocalServerConnection getLocalServerConnection() {
        return this.localServerConnection;
    }

    public void setRequestContentLength(int length) {
        this.isChunked = length == -1;
    }

    public void prepareRequest(String uri, SOAPMessageOutputter messageOutputter, MsgBodyGenerator requestBodySource) throws IOException {
        this.addTransferEncodingHeaderIfNeeded();
        this.updatePaths(uri);
        this.setMethod("POST");
        if (this.isSendingRequestUsingStream(requestBodySource)) {
            this.prepareLocalRequestUsingStream(requestBodySource);
        } else if (this.isSendingRequestUsingEnvelope(messageOutputter)) {
            this.prepareLocalRequestUsingEnvelope(messageOutputter);
        } else {
            throw new RuntimeException("Can't handle this request locally...");
        }
    }

    private void addTransferEncodingHeaderIfNeeded() {
        if (this.isChunked) {
            this.setRequestHeader("Transfer-Encoding", "chunked");
        }
    }

    public void setRequestHeader(String name, String value) {
        this.clearHeaders(name);
        this.setHeader(name, value);
    }

    private boolean isSendingRequestUsingEnvelope(SOAPMessageOutputter messageOutputter) {
        return messageOutputter != null;
    }

    private void prepareLocalRequestUsingEnvelope(SOAPMessageOutputter messageOutputter) {
        this.setRequestEnvelope(messageOutputter.getEnvelope());
        this.setContentType(messageOutputter.getContentType());
    }

    private boolean isSendingRequestUsingStream(MsgBodyGenerator requestBodySource) {
        return requestBodySource != null;
    }

    private void prepareLocalRequestUsingStream(MsgBodyGenerator requestBodySource) throws IOException {
        this.setContentType();
        this.setRequestStream(requestBodySource);
    }

    private void setContentType() {
        String contentType = this.getHeader("content-type");
        this.setContentType(contentType);
    }

    public void setRequestStream(MsgBodyGenerator requestBodySource) throws IOException {
        InOutStream requestStream = new InOutStream();
        requestBodySource.writeBody(requestStream);
        this.clientRequestStream.setStream(requestStream);
    }

    public InputStream getClientStream() {
        return this.clientRequestStream;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String arg0) {
        return 0L;
    }

    public String getHeader(String name) {
        List<String> values = this.getValues(name.toLowerCase());
        return values.isEmpty() ? null : values.get(0);
    }

    private List<String> getValues(String name) {
        ArrayList values = this.headers.get(name = StringUtils.lowerCase((String)name));
        return values != null ? values : new ArrayList();
    }

    public void setHeader(String name, String value) {
        name = StringUtils.lowerCase((String)name);
        List<String> values = this.getValues(name);
        values.add(value);
        this.headers.put(name, values);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void clearHeaders(String name) {
        this.getValues(name).clear();
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList<String> keys = new ArrayList<String>(this.headers.keySet());
        return new Enumerator(keys);
    }

    public Enumeration<String> getHeaders(String arg0) {
        List<String> values = this.getValues(arg0);
        return new Enumerator(values);
    }

    public int getIntHeader(String arg0) {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRequestURI() {
        return null;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean arg0) {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return this.getClass().getName().equals(role);
    }

    public Object getAttribute(String arg0) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.servletRequestStream;
    }

    public String getLocalAddr() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public String getParameter(String arg0) {
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String arg0) {
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public BufferedReader getReader() throws IOException {
        return this.servletRequestStream.getReader();
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String arg0) {
    }

    public void setAttribute(String arg0, Object arg1) {
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setRequestString(String requestString) {
        this.servletRequestStream.setRequestString(requestString);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void updatePaths(String uri) {
        NodeID self = NodeID.getSelf();
        this.setContextPath(self.getContext());
        this.setServletPath(self.getServletPath());
        String path = self.getPath();
        if (uri != null && path != null && uri.startsWith(path)) {
            this.setPathInfo(uri.substring(path.length()));
        }
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setReader(Reader reader) {
        this.servletRequestStream.setReader(reader);
    }

    public void setRequestEnvelope(SOAPXMLSource envelope) {
        this.envelope = (BIBusEnvelope)envelope;
    }

    @Override
    public BIBusEnvelope getEnvelope() {
        return this.envelope;
    }

    public void logRequest() {
        log.debug(this.getClass().getSimpleName());
        log.debug("   contentType: ", this.contentType);
        log.debug("   requestString: ", this.servletRequestStream.getRequestString());
        log.debug("   queryString: ", this.queryString);
        log.debug("   pathInfo: ", this.pathInfo);
        log.debug("   method: ", this.method);
        log.debug("   authType: ", this.authType);
        log.debug("   pathTranslated: ", this.pathTranslated);
        log.debug("   serverName: ", this.serverName);
        log.debug("   contextPath: ", this.contextPath);
        log.debug("   servletPath: ", this.servletPath);
        log.debug("   protocol: ", this.protocol);
        log.debug("   remoteUser: ", this.remoteUser);
        log.debug("   remoteAddr: ", this.remoteAddr);
        log.debug("   serverPort: ", this.serverPort);
        log.debug("   contentType: ", this.contentType);
        log.debug("   contentLength: ", this.contentLength);
        log.debug("   headers: ");
        for (String name : this.headers.keySet()) {
            for (String value : this.headers.get(name)) {
                log.debug("      ", name, "=", value);
            }
        }
        log.debug("   request envelope (", log.getClassName(this.envelope), "): ", this.envelope);
    }

    private class Enumerator
    implements Enumeration<String> {
        private Iterator<String> listIterator;

        public Enumerator(List<String> list) {
            this.listIterator = list.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.listIterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.listIterator.next();
        }
    }
}

