/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.inprocess;

import com.cognos.pogo.http.inprocess.ClientStream;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.http.inprocess.LocalServletMessage;
import com.cognos.pogo.http.inprocess.ServletResponseStream;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;

public class LocalServletResponse
implements HttpServletResponse,
LocalServletMessage {
    private static final PogoLogger log = PogoLogger.getLogger();
    private ClientStream clientResponseStream;
    private ServletResponseStream servletResponseStream;
    private final HashMap<String, String> headerList = new HashMap();
    private String contentType;
    private boolean isCommitted;
    private MessageContext servletMessageContext;
    private int status;

    public LocalServletResponse(LocalServerConnection localServerConnection) {
        this.clientResponseStream = new ClientStream(this);
        this.servletResponseStream = new ServletResponseStream();
    }

    public InputStream getClientStream() throws IOException {
        return this.clientResponseStream;
    }

    public ServletResponseStream getServletStream() {
        return this.servletResponseStream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.getServletStream();
    }

    public void addCookie(Cookie arg0) {
    }

    public void addDateHeader(String arg0, long arg1) {
    }

    public void addHeader(String header, String value) {
        this.setHeader(header, value);
    }

    public void addIntHeader(String arg0, int arg1) {
    }

    public boolean containsHeader(String header) {
        return this.headerList.containsKey(header);
    }

    public String encodeRedirectURL(String arg0) {
        return null;
    }

    public String encodeRedirectUrl(String arg0) {
        return null;
    }

    public String encodeURL(String arg0) {
        return null;
    }

    public String encodeUrl(String arg0) {
        return null;
    }

    public void sendError(int arg0) throws IOException {
    }

    public void sendError(int arg0, String arg1) throws IOException {
    }

    public void sendRedirect(String arg0) throws IOException {
    }

    public void setDateHeader(String arg0, long arg1) {
    }

    public void setHeader(String header, String value) {
        if (!this.isCommitted()) {
            this.headerList.put(header, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String arg1) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void flushBuffer() throws IOException {
    }

    public int getBufferSize() {
        return 0;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return null;
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void commit() {
        this.isCommitted = true;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int arg0) {
    }

    public void setCharacterEncoding(String arg0) {
    }

    public void setContentLength(int contentLength) {
        this.setIntHeader("Content-Length", contentLength);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLocale(Locale arg0) {
    }

    public String getHeader(String name) {
        return this.headerList.get(name);
    }

    public HashMap<String, String> getHeaderList() {
        return this.headerList;
    }

    public void setMessageContext(MessageContext servletMessageContext) {
        this.servletMessageContext = servletMessageContext;
    }

    @Override
    public BIBusEnvelope getEnvelope() {
        return (BIBusEnvelope)this.getProperty("response.envelope");
    }

    private Object getProperty(String propertyName) {
        return this.servletMessageContext != null ? this.servletMessageContext.getProperty(propertyName) : null;
    }

    public static void saveMessageContext(HttpServletResponse response, MessageContext mc) {
        if (response instanceof LocalServletResponse) {
            ((LocalServletResponse)response).setMessageContext(mc);
        }
    }

    public Header[] getResponseHeaders() {
        return new Header[0];
    }

    public void prepareResponse() throws IOException {
        this.propagateResponseStream();
        this.logResponse();
    }

    private void propagateResponseStream() throws IOException {
        this.clientResponseStream.setStream(this.servletResponseStream.getOutputStreamFromServlet());
        this.servletResponseStream = null;
    }

    private void logResponse() {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug(this.getClass().getSimpleName(), ":");
        log.debug("   contentType: ", this.contentType);
        log.debug("   status: ", this.status);
        log.debug("   isCommitted: ", this.isCommitted);
        log.debug("   headers: ");
        for (String name : this.headerList.keySet()) {
            log.debug("      ", name, "=", this.headerList.get(name));
        }
        BIBusEnvelope envelope = this.getEnvelope();
        log.debug("   envelope (", log.getClassName(envelope), "): ", envelope);
        log.debug("   clientResponseStream: ", this.clientResponseStream);
    }

    public void postponeStreaming(Iterator<InputStream> attachments, byte[] startMimeBoundary, byte[] endMimeBoundary) {
        this.clientResponseStream.postponeStreaming(attachments, startMimeBoundary, endMimeBoundary);
    }
}

