/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.mime;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.http.mime.ClearOnCloseByteArrayInputStream;
import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class CachedFileInputStream
extends InputStream {
    private static final PogoLogger log = PogoLogger.getLogger();
    private InputStream memoryStream;
    private FileInputStream fileStream;
    private File tempFile;
    private long limit;
    private long filesize;
    private long memorySize;
    private long pos;
    private long markPos;

    public CachedFileInputStream(InputStream inStream, long limit) throws IOException {
        this.limit = limit;
        this.createStreams(inStream);
    }

    private void createStreams(InputStream inStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.memorySize = (int)IOUtils.copyLarge((InputStream)inStream, (OutputStream)output, (long)0L, (long)this.limit);
        this.memoryStream = new ClearOnCloseByteArrayInputStream(output.toByteArray());
        log.debug("Created in memory cache size=", this.memorySize);
        if (this.memorySize >= this.limit && this.limit != -1L) {
            this.copyInputToTempFile(inStream);
            this.fileStream = new FileInputStream(this.tempFile);
        }
    }

    private void copyInputToTempFile(InputStream inStream) throws IOException {
        String tempDir = PropertyInserter.getProperty("dispatcher.temp");
        this.tempFile = File.createTempFile("Mime", ".tmp", tempDir == null ? null : new File(tempDir));
        FileOutputStream output = new FileOutputStream(this.tempFile);
        this.filesize = IOUtils.copyLarge((InputStream)inStream, (OutputStream)output, (long)0L, (long)-1L);
        ((OutputStream)output).close();
        log.debug("Created temp file ", this.tempFile, " size= ", this.filesize);
    }

    @Override
    public void close() throws IOException {
        this.memoryStream.close();
        if (this.fileStream != null) {
            this.fileStream.close();
            log.debug("Deleted temp file ", this.tempFile);
            this.tempFile.delete();
        }
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.markPos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.fileStream != null) {
            this.fileStream.close();
            this.fileStream = new FileInputStream(this.tempFile);
        }
        this.pos = 0L;
        this.memoryStream.reset();
        this.skip(this.markPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        return this.pos++ < this.limit || this.limit == -1L ? this.memoryStream.read() : this.fileStream.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        int bytesRead = 0;
        int bytesRead2 = 0;
        if (this.pos < this.limit || this.limit == -1L) {
            int bytesToRead = this.limit == -1L ? len : (int)Math.min(this.limit - this.pos, (long)len);
            bytesRead = this.memoryStream.read(buffer, offset, bytesToRead);
        }
        if (bytesRead != -1 && bytesRead < len && this.limit != -1L && this.fileStream != null) {
            bytesRead2 = this.fileStream.read(buffer, offset + bytesRead, len - bytesRead);
        }
        if (bytesRead == -1 || bytesRead2 == -1) {
            this.pos = this.memorySize + this.filesize;
            return -1;
        }
        this.pos += (long)(bytesRead + bytesRead2);
        return bytesRead + bytesRead2;
    }

    @Override
    public long skip(long skipCount) throws IOException {
        long memorySkip = 0L;
        long fileSkip = 0L;
        if (this.pos < this.limit || this.limit == -1L) {
            memorySkip = this.memoryStream.skip(skipCount);
        }
        if (memorySkip < skipCount) {
            fileSkip = this.fileStream.skip(skipCount - memorySkip);
        }
        this.pos += memorySkip + fileSkip;
        return memorySkip + fileSkip;
    }

    File getTempFile() {
        return this.tempFile;
    }
}

