/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.mime;

import com.cognos.pogo.http.mime.MimeParseInputStream;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MIMEPartParser
implements Iterator {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String BOUNDARY_NAME = "boundary=";
    private byte[] boundary;
    private MimeParseInputStream mpis;
    private CountDownLatch fileClosedLatch = new CountDownLatch(1);

    public MIMEPartParser(InputStream is, String sboundary) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("--").append(sboundary);
        this.boundary = sb.toString().getBytes();
        this.mpis = new MimeParseInputStream(is, this.boundary);
        this.mpis.mark(0);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.mpis.hasNext();
        }
        catch (IOException iox) {
            log.error("IOException while advancing to next part.", iox);
            return false;
        }
    }

    public Object next() {
        log.debug("next");
        try {
            this.mpis.advance();
            return this.mpis;
        }
        catch (IOException iox) {
            log.error("advance failed.", iox);
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static String getBoundaryFromContentType(String contentType) {
        int boundaryPos = contentType.indexOf(BOUNDARY_NAME);
        if (boundaryPos == -1) {
            log.debug("'boundary=' is not found.  This is not a proper multipart message");
            return null;
        }
        int isc = contentType.indexOf(59, boundaryPos += BOUNDARY_NAME.length());
        String multiPartBoundary = isc != -1 ? contentType.substring(boundaryPos, isc) : contentType.substring(boundaryPos);
        if ((multiPartBoundary = multiPartBoundary.trim()).startsWith("\"") && multiPartBoundary.endsWith("\"")) {
            multiPartBoundary = multiPartBoundary.substring(1, multiPartBoundary.length() - 1);
        }
        return multiPartBoundary;
    }

    public boolean rewindAttachment() {
        boolean attachWasReWound = false;
        if (this.mpis.markSupported()) {
            try {
                this.mpis.reset();
                attachWasReWound = true;
            }
            catch (IOException iox) {
                log.error("IOException while rewinding attachment", iox);
            }
        }
        return attachWasReWound;
    }

    public void close() {
        this.fileClosedLatch.countDown();
        log.debug("Closing the MimeParseInputStream upstream");
        this.mpis.closeUpstream();
    }

    public void await(long timeout) throws InterruptedException {
        this.fileClosedLatch.await(timeout, TimeUnit.MILLISECONDS);
    }
}

