/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.impl.IDispatcherStrings;
import com.cognos.pogo.impl.SingleQuoteEscaper;
import com.cognos.pogo.util.Check;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DispatcherStringsImpl
implements IDispatcherStrings {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(DispatcherStringsImpl.class.getName());
    private static final String RESOURCE_PROPERTIES = "DispatcherMessages";
    private static IDispatcherStrings instance = new DispatcherStringsImpl();
    private Locale serverLocale;
    private Map<String, String> mapBundlesByPrefix = Collections.synchronizedMap(new HashMap());

    protected DispatcherStringsImpl() {
        ICCLConfiguration cclConfig = CCLConfigurationFactory.createConfiguration();
        try {
            cclConfig.init();
            String serverLocaleStr = cclConfig.getValue("serverLocale", false);
            if (serverLocaleStr == null || "".equals(serverLocaleStr)) {
                logger.warn("ICCLConfiguration did not return a valid server locale.  Using the VM's default locale.");
                this.serverLocale = Locale.getDefault();
                return;
            }
            int indexOfDash = serverLocaleStr.indexOf(45);
            this.serverLocale = indexOfDash == -1 ? new Locale(serverLocaleStr, "") : new Locale(serverLocaleStr.substring(0, indexOfDash), serverLocaleStr.substring(indexOfDash + 1));
        }
        catch (CCLConfigurationException ex) {
            logger.warn("ICCLConfiguration did not initialize properly.  Could not retrieve the server locale.  Using the VM's default locale", (Throwable)ex);
            this.serverLocale = Locale.getDefault();
        }
    }

    public static IDispatcherStrings getInstance() {
        return instance;
    }

    @Override
    public void registerResourceBundle(String messagePrefix, String bundleName) {
        this.mapBundlesByPrefix.put(messagePrefix, bundleName);
    }

    private String getStringFromBundle(String key, Locale locale) throws MissingResourceException {
        String prefix;
        String bname;
        String bundleName = RESOURCE_PROPERTIES;
        int pos = key.indexOf(46);
        if (pos > 0 && (bname = this.mapBundlesByPrefix.get(prefix = key.substring(0, pos))) != null) {
            bundleName = bname;
            if (logger.isDebugEnabled()) {
                logger.debug("will use bundle: \"" + bundleName + "\" for message key: \"" + key + "\"");
            }
        }
        return this.getResourceBundleString(key, locale, bundleName);
    }

    protected String getResourceBundleString(String key, Locale locale, String bundleName) throws MissingResourceException {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale);
        return bundle.getString(key);
    }

    @Override
    public String getString(String key) throws MissingResourceException {
        Check.notNull(key);
        return this.getStringFromBundle(key, this.serverLocale);
    }

    @Override
    public String getString(String key, Locale locale) throws MissingResourceException {
        Check.notNull(key);
        Check.notNull(locale);
        return this.getStringFromBundle(key, locale);
    }

    @Override
    public String getString(String key, Locale locale, Object[] parameters) throws MissingResourceException {
        String message = this.getString(key, locale);
        if (message == null) {
            return null;
        }
        int singleQuotePos = message.indexOf("'");
        if (singleQuotePos != -1) {
            message = SingleQuoteEscaper.escape(message);
        }
        return MessageFormat.format(message, parameters);
    }

    @Override
    public String getString(String key, Object[] parameters) throws MissingResourceException {
        return this.getString(key, this.serverLocale, parameters);
    }
}

