/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import javax.servlet.http.Cookie;

public class SetCookieEncoder {
    static final String FIELD_SEPARATOR = "; ";
    static final String EQUAL = "=";
    static final String DOMAIN = "Domain";
    static final String PATH = "Path";
    static final String MAX_AGE = "Max-Age";
    static final String SECURE = "Secure";
    static final String HTTPONLY = "HttpOnly";
    static final String CAM_PASSPORT = "cam_passport";
    private Cookie cookie = null;
    private boolean camPassportHttpOnlySet;

    public SetCookieEncoder(Cookie cookie) {
        this(cookie, false);
    }

    public SetCookieEncoder(Cookie cookie, boolean httpOnlySet) {
        if (cookie == null) {
            throw new IllegalArgumentException("Undefined Cookie");
        }
        this.cookie = cookie;
        this.camPassportHttpOnlySet = httpOnlySet;
    }

    public String generateSetCookie() {
        String setCookie = null;
        StringBuffer buffer = null;
        String fieldValue = null;
        if (this.cookie.getName() != null && this.cookie.getName().trim().length() > 0) {
            buffer = new StringBuffer();
            buffer.append(this.generateInitialFieldValue(this.cookie.getName(), this.cookie.getValue()));
            fieldValue = this.cookie.getDomain();
            if (fieldValue != null && fieldValue.trim().length() > 0) {
                buffer.append(this.generateAdditionalValueField(DOMAIN, fieldValue.trim()));
            }
            if (this.cookie.getMaxAge() >= 0) {
                buffer.append(this.generateAdditionalValueField(MAX_AGE, Integer.toString(this.cookie.getMaxAge())));
            }
            if ((fieldValue = this.cookie.getPath()) != null && fieldValue.trim().length() > 0) {
                buffer.append(this.generateAdditionalValueField(PATH, fieldValue.trim()));
            }
            if (this.cookie.getSecure()) {
                buffer.append(this.generateAdditionalField(SECURE));
            }
            if (this.shouldSetHttpOnlyAttrib()) {
                buffer.append(this.generateFlagField(HTTPONLY));
            }
        }
        if (buffer != null) {
            setCookie = buffer.toString();
        }
        return setCookie;
    }

    private String generateInitialFieldValue(String name, String value) {
        String field = name + EQUAL;
        if (value != null && value.trim().length() > 0) {
            field = field + value.trim();
        }
        return field;
    }

    private String generateAdditionalField(String name) {
        return FIELD_SEPARATOR + name;
    }

    private String generateAdditionalValueField(String name, String value) {
        return FIELD_SEPARATOR + name + EQUAL + value.trim();
    }

    private String generateFlagField(String name) {
        return FIELD_SEPARATOR + name;
    }

    private boolean shouldSetHttpOnlyAttrib() {
        return this.camPassportHttpOnlySet && this.cookie.getName().equalsIgnoreCase(CAM_PASSPORT);
    }
}

