/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.isolation;

import com.cognos.pogo.isolation.ParanoidClassLoader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class ServletWrapper
extends HttpServlet {
    public static final String ORIGINAL_WEBAPP_CLASSLOADER_NAME = "originalClassloader";
    protected static final String CONTEXT_PREFIX = "context:";
    protected static final String FILE_PREFIX = "file:";
    protected Servlet servlet;
    protected ClassLoader classloader;
    protected ArrayList<String> excludeList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String classLoaderName = config.getInitParameter("classLoaderName");
        if (classLoaderName == null) {
            throw new ServletException("Missing classLoaderName init parameter.");
        }
        ServletContext servletContext = config.getServletContext();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Object o = servletContext.getAttribute(classLoaderName);
        if (o != null && o instanceof ClassLoader) {
            this.log("Using class loader in the servlet context:" + o.toString());
            this.classloader = (ClassLoader)o;
        } else {
            this.log("Creating a paranoid class loader.");
            String externalClasspath = config.getInitParameter("paranoid-classpath");
            boolean usePlatformJMX = this.getUsePlatformJMX(config);
            this.populateExcludeList(config.getInitParameter("classLoaderExclude"));
            this.classloader = externalClasspath == null ? this.getClassLoader(this.getContextDir(), usePlatformJMX) : this.getClassLoader(externalClasspath, this.getContextDir(), usePlatformJMX);
            servletContext.setAttribute(classLoaderName, (Object)this.classloader);
            servletContext.setAttribute(ORIGINAL_WEBAPP_CLASSLOADER_NAME, (Object)old);
        }
        String servletName = config.getInitParameter("servlet-class");
        if (servletName == null) {
            throw new ServletException("Missing servlet-class init parameter.");
        }
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Class<?> servletClass = this.classloader.loadClass(servletName);
                this.servlet = (Servlet)servletClass.newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Cannot load servlet " + servletName, (Throwable)e);
            }
            this.initServlet();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected void populateExcludeList(String list) {
        this.excludeList.clear();
        if (list == null || list.length() == 0) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            String jarFile = tokens.nextToken().trim();
            this.log("Excluding " + jarFile + " from class loader list");
            this.excludeList.add(jarFile);
        }
    }

    private boolean getUsePlatformJMX(ServletConfig config) {
        String initParameter = config.getInitParameter("usePlatformJMX");
        return Boolean.valueOf(initParameter);
    }

    protected void initServlet() throws ServletException {
        this.servlet.init(this.getServletConfig());
    }

    protected File getContextDir() throws ServletException {
        String result = this.getServletContext().getRealPath("/");
        if (result == null) {
            throw new ServletException(((Object)((Object)this)).getClass().getName() + " cannot run in an undeployed WAR file");
        }
        try {
            return new File(result).getCanonicalFile();
        }
        catch (IOException e) {
            throw new ServletException("cannot convert context dir to canonical form", (Throwable)e);
        }
    }

    protected ClassLoader getClassLoader(File contextDir, boolean usePlatformJMX) throws ServletException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            File classDir = new File(contextDir + "/WEB-INF/classes");
            if (classDir.exists()) {
                if (!classDir.isDirectory()) {
                    throw new ServletException(classDir + " exists but is not a directory");
                }
                URL classURL = classDir.toURL();
                this.log("Adding class directory " + classURL);
                urlList.add(classURL);
            }
            File libDir = new File(contextDir + "/WEB-INF/lib");
            File[] libraries = libDir.listFiles(new JarFileFilter());
            for (int i = 0; i < libraries.length; ++i) {
                URL lib = libraries[i].toURL();
                this.log("Adding class library " + lib);
                urlList.add(lib);
            }
        }
        catch (MalformedURLException mue) {
            throw new ServletException((Throwable)mue);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return this.getParanoidClassLoader(urls, usePlatformJMX);
    }

    protected ClassLoader getClassLoader(String externalClasspath, File contextDir, boolean usePlatformJMX) throws ServletException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        this.log("Adding classpath from " + externalClasspath);
        try {
            String line;
            FileReader fileReader = new FileReader(externalClasspath);
            LineNumberReader lineReader = new LineNumberReader(fileReader);
            do {
                if ((line = lineReader.readLine()) == null) continue;
                if (line.startsWith("class-dir:")) {
                    if ((line = line.substring("class-dir:".length()).trim()).startsWith(CONTEXT_PREFIX)) {
                        line = contextDir + line.substring(CONTEXT_PREFIX.length());
                    }
                    URL url = new File(line).toURL();
                    this.log("Adding class directory " + url);
                    urlList.add(url);
                    continue;
                }
                if (line.startsWith("lib-dir:")) {
                    if ((line = line.substring("lib-dir:".length()).trim()).startsWith(CONTEXT_PREFIX)) {
                        line = contextDir + line.substring(CONTEXT_PREFIX.length());
                    }
                    File dir = new File(line);
                    File[] libraries = dir.listFiles(new JarFileFilter());
                    this.log("Adding " + libraries.length + " libraries from " + dir.toURL());
                    for (int i = 0; i < libraries.length; ++i) {
                        URL url = libraries[i].toURL();
                        urlList.add(url);
                    }
                } else {
                    URL lib;
                    if (line.startsWith("#")) continue;
                    if (line.startsWith(CONTEXT_PREFIX)) {
                        line = "file:/" + contextDir + line.substring(CONTEXT_PREFIX.length()).trim();
                    }
                    if (line.indexOf(58) == -1) {
                        File entry = new File(line);
                        lib = entry.toURL();
                    } else {
                        lib = new URL(line);
                    }
                    this.log("Adding class URL " + lib);
                    urlList.add(lib);
                }
            } while (line != null);
            lineReader.close();
        }
        catch (IOException io) {
            throw new ServletException((Throwable)io);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return this.getParanoidClassLoader(urls, usePlatformJMX);
    }

    private URLClassLoader getParanoidClassLoader(URL[] urls, boolean usebuiltInJMX) {
        return ParanoidClassLoader.newInstance(urls, ((Object)((Object)this)).getClass().getClassLoader(), usebuiltInJMX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.servlet.service(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void destroy() {
        if (this.servlet != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classloader);
                this.servlet.destroy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        super.destroy();
    }

    protected class JarFileFilter
    implements FilenameFilter {
        protected JarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return ServletWrapper.this.excludeList.contains(name) ? false : name.endsWith(".zip") || name.endsWith(".jar");
        }
    }
}

