/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.p2pd.util.DOMWriter;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.pdk.common.BodyFaultDetail;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.pdk.common.BodyFaultMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AuditLogMsg {
    private String operation;
    private StringBuffer sbLogData;
    private ArrayList<String> errorMessages;
    private String objectType;
    private String objectPath;
    private String status;
    private Level level;

    private StringBuffer getLogDataSB() {
        if (this.sbLogData == null) {
            this.sbLogData = new StringBuffer();
        }
        return this.sbLogData;
    }

    private String closeLogData() {
        if (this.sbLogData != null) {
            return this.sbLogData.toString();
        }
        return "";
    }

    private ArrayList<String> getErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList();
        }
        return this.errorMessages;
    }

    public AuditLogMsg(Level level) {
        this.level = level;
    }

    protected abstract LogAuditIndication getIndication(LoggingRealm var1);

    LogAuditIndication generateIndication(LoggingRealm realm) {
        LogAuditIndication ind = this.getIndication(realm);
        this.prepareIndication(ind);
        return ind;
    }

    protected void prepareIndication(LogAuditIndication ind) {
        ind.setLevel(this.getLevel().toInt());
        ind.setLogData(this.closeLogData());
        ind.setOperation(this.operation);
        if (ind instanceof LogAuditAccessIndication) {
            LogAuditAccessIndication accind = (LogAuditAccessIndication)ind;
            accind.setErrorMessage(this.formatErrorMessages());
            accind.setObjectType(this.objectType);
            accind.setObjectPath(this.objectPath);
            accind.setStatus(this.status);
        }
    }

    private String formatErrorMessages() {
        if (this.errorMessages == null || this.errorMessages.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<messages>");
        for (int i = 0; i < this.errorMessages.size(); ++i) {
            sb.append("<message><messageString>");
            sb.append(DOMWriter.normalize(this.errorMessages.get(i), true));
            sb.append("</messageString></message>");
        }
        sb.append("</messages>");
        return sb.toString();
    }

    public void setLogData(String logData) {
        StringBuffer sb = this.getLogDataSB();
        sb.append(logData);
    }

    public void setErrorMessage(String msg) {
        this.addErrorMessage(msg);
    }

    public void addErrorMessage(String msg) {
        if (msg != null) {
            this.getErrorMessages().add(msg);
        }
    }

    public void addErrorMessage(Throwable x) {
        this.getErrorMessages().add(x.getLocalizedMessage());
        StackTraceIterator sti = new StackTraceIterator(x);
        while (sti.hasNext()) {
            this.setLogData((String)sti.next());
        }
    }

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Level getLevel() {
        return this.level;
    }

    protected void setLevel(Level level) {
        this.level = level;
    }

    protected void harvestMessages(BodyFaultDetail bodyFaultDetail) {
        int messageCount = 0;
        List<BodyFaultException> exceptions = bodyFaultDetail.getExceptions();
        for (BodyFaultException bodyFaultException : exceptions) {
            List<BodyFaultMessage> messages = bodyFaultException.getMessages();
            for (BodyFaultMessage bodyFaultMessage : messages) {
                String message = bodyFaultMessage.getMessageString();
                if (messageCount++ == 0) {
                    if (message == null) continue;
                    this.addErrorMessage(message);
                    continue;
                }
                if (message == null) continue;
                this.setLogData(message);
            }
        }
    }

    private String getMessageFromElement(Node node) {
        if (node instanceof Element) {
            Element msg = (Element)node;
            return msg.getStringValue();
        }
        return null;
    }

    class StackTraceIterator
    implements Iterator<Object> {
        private StringTokenizer tokenizer = null;

        public StackTraceIterator(Throwable x) {
            if (x == null) {
                return;
            }
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            w.println(x.getMessage());
            x.printStackTrace(w);
            w.close();
            this.tokenizer = new StringTokenizer(sw.toString(), "\n");
        }

        @Override
        public boolean hasNext() {
            return this.tokenizer != null && this.tokenizer.hasMoreTokens();
        }

        public String nextToken() {
            return this.tokenizer.nextToken();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return this.tokenizer.nextElement();
        }
    }
}

