/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.logging;

import com.cognos.indications.LogIndication;

public class LoggingContext
extends ThreadLocal<Object> {
    private String sessionID;
    private String requestID;
    private String subRequestID;
    private String stepID;
    private static final String defStepID = "";
    private static final String defRequestID = "na";
    private static final String defSessionID = "na";
    private static final String defSubRequestID = "";

    @Override
    protected Object initialValue() {
        LoggingContext lc = LoggingContext.createDefaultContext();
        return lc;
    }

    LoggingContext() {
    }

    public LoggingContext(String requestID, long hopCount) {
        this.requestID = requestID;
        this.subRequestID = Long.toString(hopCount);
        this.stepID = "";
        this.sessionID = "na";
    }

    public String getRequestID() {
        return this.requestID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getStepID() {
        return this.stepID;
    }

    public String getSubRequestID() {
        return this.subRequestID;
    }

    public void setRequestID(String requestID) {
        this.requestID = requestID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setStepID(String stepID) {
        this.stepID = stepID;
    }

    public void setSubRequestID(String subRequestID) {
        this.subRequestID = subRequestID;
    }

    static LoggingContext createDefaultContext() {
        LoggingContext defaultContext = new LoggingContext();
        defaultContext.requestID = "na";
        defaultContext.sessionID = "na";
        defaultContext.stepID = "";
        defaultContext.subRequestID = "";
        return defaultContext;
    }

    void prepareIndication(LogIndication ind) {
        ind.setRequestID(this.getRequestID());
        ind.setSessionID(this.getSessionID());
        ind.setStepID(this.getStepID());
        ind.setSubRequestID(this.getSubRequestID());
    }
}

