/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.logging;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.pogo.logging.LoggingContext;
import com.cognos.pogo.logging.Slogger;

public class LoggingRealm {
    private String componentName;
    private int buildNum;
    private static LoggingContext loggingContext = new LoggingContext();

    LoggingRealm(String componentName, int buildNum) {
        this.componentName = componentName;
        this.buildNum = buildNum;
    }

    public Slogger getLogger(String name) {
        return new Slogger(this, name);
    }

    public void setLoggingContext(LoggingContext context) {
        loggingContext.set(context);
    }

    public void clearLoggingContext() {
        loggingContext.set(null);
    }

    public LoggingContext getLoggingContext() {
        Object context = loggingContext.get();
        if (context == null) {
            context = loggingContext.initialValue();
        }
        return (LoggingContext)context;
    }

    public int getBuildNum() {
        return this.buildNum;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public LogAuditIndication getAuditIndication() {
        LogAuditIndication ind = new LogAuditIndication(this.componentName, this.buildNum);
        this.getLoggingContext().prepareIndication((LogIndication)ind);
        return ind;
    }

    public LogAuditAccessIndication getAuditAccessIndication() {
        LogAuditAccessIndication ind = new LogAuditAccessIndication(this.componentName, this.buildNum);
        this.getLoggingContext().prepareIndication((LogIndication)ind);
        return ind;
    }

    public LogTraceIndication getTraceIndication() {
        LogTraceIndication ind = new LogTraceIndication(this.componentName, this.buildNum);
        this.getLoggingContext().prepareIndication((LogIndication)ind);
        return ind;
    }

    public LogPerfIndication getPerfIndication(CCLResourceCounterSet lcs) {
        LogPerfIndication ind = new LogPerfIndication(this.componentName, this.buildNum, lcs);
        this.getLoggingContext().prepareIndication((LogIndication)ind);
        return ind;
    }
}

