/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.util.PogoLogger;

public enum OperationalStatus {
    unknown,
    Available,
    PartiallyAvailable,
    Unavailable,
    Dormant;

    private static final int NR_OF_STATUSES = 5;
    private static final PogoLogger log;
    private OperationalStatus[] aggregationRules = new OperationalStatus[5];

    private void setAggregationRule(OperationalStatus newServiceStatus, OperationalStatus aggregatedOperationalStatus) {
        this.aggregationRules[newServiceStatus.ordinal()] = aggregatedOperationalStatus;
    }

    public OperationalStatus aggregate(OperationalStatus newServiceStatus) {
        OperationalStatus aggregatedOperationalStatus = this.aggregationRules[newServiceStatus.ordinal()];
        return aggregatedOperationalStatus == null ? this : aggregatedOperationalStatus;
    }

    public static OperationalStatus safeValueOf(Object status) {
        String statusName = String.valueOf(status);
        try {
            return OperationalStatus.valueOf(statusName);
        }
        catch (Exception e) {
            log.warn("Invalid operational status [" + statusName + "]. Using default.", e);
            return unknown;
        }
    }

    static {
        log = PogoLogger.getLogger();
        unknown.setAggregationRule(Available, Available);
        unknown.setAggregationRule(PartiallyAvailable, PartiallyAvailable);
        unknown.setAggregationRule(Unavailable, Unavailable);
        Available.setAggregationRule(PartiallyAvailable, PartiallyAvailable);
        Available.setAggregationRule(Unavailable, PartiallyAvailable);
        Unavailable.setAggregationRule(Available, PartiallyAvailable);
        Unavailable.setAggregationRule(PartiallyAvailable, PartiallyAvailable);
    }
}

