/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.monitoring.CounterBase;
import com.cognos.pogo.monitoring.OperationalStatus;
import java.util.HashMap;

public class ServiceStatus
extends CounterBase {
    public static final String STARTING = "starting";
    public static final String STARTED = "running";
    public static final String STOPPING = "stopping";
    public static final String STOPPED = "suspended";
    public static final String SUSPENDED = "suspended";
    public static final String STANDBY = "standby";
    public static final String FAILED = "failed";
    public static final String DORMANT = "dormant";
    public static final String UNKNOWN = OperationalStatus.unknown.toString();
    public static final String AVAILABLE = OperationalStatus.Available.toString();
    public static final String PARTIALLYAVAILABLE = OperationalStatus.PartiallyAvailable.toString();
    public static final String UNAVAILABLE = OperationalStatus.Unavailable.toString();
    public static final String AVAILABLE_DORMANT = OperationalStatus.Dormant.toString();
    private static final HashMap<String, String> muwsStateMap = new HashMap();
    private String state = UNKNOWN;

    public ServiceStatus() {
        super("state");
    }

    @Override
    public void getXML(StringBuffer sb) {
        sb.append('<').append(this.getName());
        sb.append(" state=\"").append(this.state);
        sb.append("\"/>");
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public static String getMuwsState(String state) {
        return muwsStateMap.get(state);
    }

    @Override
    public void reset() {
    }

    static {
        muwsStateMap.put(UNKNOWN, UNKNOWN);
        muwsStateMap.put(STARTING, UNAVAILABLE);
        muwsStateMap.put(STARTED, AVAILABLE);
        muwsStateMap.put(STOPPING, PARTIALLYAVAILABLE);
        muwsStateMap.put("suspended", UNAVAILABLE);
        muwsStateMap.put("suspended", PARTIALLYAVAILABLE);
        muwsStateMap.put(STANDBY, AVAILABLE);
        muwsStateMap.put(FAILED, UNAVAILABLE);
        muwsStateMap.put(DORMANT, AVAILABLE_DORMANT);
    }
}

