/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.impl;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.CommandExecutionIOException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.ContentManagerAddCommand;
import com.cognos.pogo.contentmanager.ContentManagerUpdateCommand;
import com.cognos.pogo.contentmanager.coordinator.CMUtils;
import com.cognos.pogo.monitoring.ReporterBase;
import com.cognos.pogo.monitoring.RuntimeInfoPublisher;
import com.cognos.pogo.monitoring.RuntimeInfoReporter;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RuntimeInfoPublisherImpl
implements RuntimeInfoPublisher {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RuntimeInfoPublisherImpl.class.getName());
    private ArrayList<RuntimeInfoReporter> reporters = new ArrayList();
    private String dispatcherSearchPath = null;
    private int interval = 0;
    private Timer timer;

    public void updateInterval(int newInterval) {
        if (newInterval != this.interval) {
            if (cat.isDebugEnabled()) {
                cat.debug("Changing update interval from " + this.interval + " to " + newInterval);
            }
            this.cancelTimer();
            this.interval = newInterval;
            this.startTimer();
        }
    }

    private void startTimer() {
        if (this.interval != 0) {
            this.timer = new Timer(true);
            ReporterPublisher task = new ReporterPublisher();
            this.timer.schedule((TimerTask)task, this.interval, (long)this.interval);
        }
    }

    private void cancelTimer() {
        if (this.interval != 0) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public void addReporter(RuntimeInfoReporter reporter) {
        this.reporters.add(reporter);
    }

    public void publishToCM() {
        this.publishToCM(true);
    }

    public boolean publishRunningStates() {
        return this.publishToCM(false);
    }

    public boolean publishToCM(boolean addReporters) {
        ContentManagerUpdateCommand updater = new ContentManagerUpdateCommand();
        try {
            for (ReporterBase reporterBase : this.reporters) {
                if (addReporters) {
                    this.addReporterToUpdate(updater, reporterBase);
                    continue;
                }
                this.addRunningStateToUpdate(updater, reporterBase);
            }
            updater.setDoTrustedRequest(true);
            updater.execute();
            cat.debug("publishing runtime info suceeded");
            return true;
        }
        catch (SoapFaultException soapFault) {
            cat.debug("Soap fault publishing to CM", (Throwable)soapFault);
        }
        catch (CommandExecutionIOException ex) {
            cat.debug("Command exception publishing to CM", (Throwable)ex);
        }
        catch (Exception x) {
            cat.warn("error occured when publishing runtime info to CM.", (Throwable)x);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReporterToUpdate(ContentManagerUpdateCommand updater, ReporterBase reporter) {
        String reporterSearchPath;
        String reporterName;
        String reporterStatus;
        StringBuffer sb = new StringBuffer();
        ReporterBase reporterBase = reporter;
        synchronized (reporterBase) {
            reporter.getXML(sb);
            reporter.reset();
            reporterStatus = reporter.getServiceStatus();
            reporterName = reporter.getServiceName();
            boolean reporterStatusChanged = reporter.isStatusChanged();
            if (reporterStatusChanged) {
                reporter.setStatusChanged(false);
            }
            reporterSearchPath = reporter.getSearchPath();
        }
        if (reporterStatus.equals(ServiceStatus.UNKNOWN)) {
            if (cat.isDebugEnabled()) {
                cat.debug("not publishing runtime info for " + reporterName + " status= " + reporterStatus);
            }
        } else {
            updater.addObject("runTimeState");
            updater.setSearchPath(reporterSearchPath + "/runTimeState[@defaultName='RunTimeState']");
            updater.setState(sb.toString());
            if (cat.isDebugEnabled()) {
                cat.debug("publishing runtime info (" + reporterName + "\n" + sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunningStateToUpdate(ContentManagerUpdateCommand updater, ReporterBase reporter) {
        String reporterServiceType;
        String reporterSearchPath;
        String reporterName;
        String reporterStatus;
        ReporterBase reporterBase = reporter;
        synchronized (reporterBase) {
            reporterStatus = reporter.getServiceStatus();
            reporterName = reporter.getServiceName();
            reporterSearchPath = reporter.getSearchPath();
            reporterServiceType = reporter.getServiceType();
        }
        if (reporterStatus.equals(ServiceStatus.UNKNOWN)) {
            if (cat.isDebugEnabled()) {
                cat.debug("not publishing runtime state for " + reporterName + " status= " + reporterStatus);
            }
        } else {
            updater.addObject(reporterServiceType);
            updater.setSearchPath(reporterSearchPath);
            updater.setRunningState(reporterStatus);
            if (cat.isDebugEnabled()) {
                cat.debug("publishing runtime state for " + reporterName + " = " + reporterStatus);
            }
        }
    }

    public synchronized void setDispatcherSearchPath(String dispatcherSearchPath) {
        if (this.dispatcherSearchPath == null || !this.dispatcherSearchPath.equals(dispatcherSearchPath)) {
            this.dispatcherSearchPath = dispatcherSearchPath;
            this.resetReporterSearchPaths(dispatcherSearchPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetReporterSearchPaths(String dispatcherSearchPath) {
        for (RuntimeInfoReporter reporter : this.reporters) {
            StringBuffer path = new StringBuffer();
            path.append(dispatcherSearchPath);
            if (!"dispatcher".equals(reporter.getServiceType())) {
                path.append("/");
                path.append(reporter.getServiceType());
            }
            RuntimeInfoReporter runtimeInfoReporter = reporter;
            synchronized (runtimeInfoReporter) {
                reporter.setSearchPath(path.toString());
            }
        }
    }

    public boolean createRunTimeInfoObjects() {
        if (this.dispatcherSearchPath == null) {
            return false;
        }
        cat.debug("adding (with update) runtime info objects, dispatcher search path is:" + this.dispatcherSearchPath);
        try {
            this.registerReportersInCM();
        }
        catch (SoapFaultException sfx) {
            cat.error("Unable to add dispatcher runTimeState to CM. SOAPFault, " + sfx.getMessage() + " -- " + sfx.getDetail());
            return false;
        }
        catch (CommandExecutionException e) {
            cat.error("Unable to add dispatcher runTimeState to CM.", (Throwable)e);
            return false;
        }
        return true;
    }

    void registerReportersInCM() throws CommandExecutionException {
        String invalidReporterServiceType = this.registerValidReportersInCM();
        while (invalidReporterServiceType != null) {
            this.removeInvalidReporter(invalidReporterServiceType);
            invalidReporterServiceType = this.registerValidReportersInCM();
        }
    }

    private void removeInvalidReporter(String invalidReporterServiceType) {
        Iterator<RuntimeInfoReporter> iterator = this.reporters.iterator();
        while (iterator.hasNext()) {
            RuntimeInfoReporter reporter = iterator.next();
            if (!reporter.getServiceType().equals(invalidReporterServiceType)) continue;
            iterator.remove();
            cat.warn("Stopping invalid reporter: " + invalidReporterServiceType + " from being registered in CM");
        }
    }

    private String registerValidReportersInCM() throws CommandExecutionException, SoapFaultException {
        ContentManagerAddCommand addCmd = this.createContentManagerAddCommand();
        addCmd.setUpdateAction("update");
        addCmd.setDoTrustedRequest(true);
        addCmd.setSearch(this.dispatcherSearchPath);
        addCmd.addObject("runTimeState");
        addCmd.setDefaultName("RunTimeState");
        for (ReporterBase reporterBase : this.reporters) {
            if ("dispatcher".equals(reporterBase.getServiceType())) {
                reporterBase.setSearchPath(this.dispatcherSearchPath);
                continue;
            }
            String path = this.dispatcherSearchPath + "/" + reporterBase.getServiceType();
            addCmd.addObject("runTimeState");
            addCmd.setSearchPath(path);
            addCmd.setDefaultName("RunTimeState");
            reporterBase.setSearchPath(path);
        }
        try {
            addCmd.execute();
        }
        catch (SoapFaultException soapFaultException) {
            String invalidService = CMUtils.getInvalidService(soapFaultException);
            if (invalidService != null) {
                return invalidService;
            }
            throw soapFaultException;
        }
        return null;
    }

    protected ContentManagerAddCommand createContentManagerAddCommand() {
        return new ContentManagerAddCommand();
    }

    public boolean isTimerStarted() {
        return this.timer != null;
    }

    public int getNumberOfReporters() {
        return this.reporters.size();
    }

    public class ReporterPublisher
    extends SafeTimerTask {
        @Override
        public void safeRun() {
            RuntimeInfoPublisherImpl.this.publishToCM();
        }
    }
}

