/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.services.attributes.ServiceAttribute;
import java.util.HashSet;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ConfigurationDynamic
implements DynamicMBean {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ConfigurationDynamic.class.getName());
    private MBeanInfo mBeanInfo = null;
    private final String description = "Simple implementation of a dynamic MBean.";
    private ConfigurationImpl configuration;
    private final Service service;
    private HashSet<String> attributeSet;
    private String serviceName;

    public ConfigurationDynamic(Service service, Configuration configuration) {
        this.service = service;
        this.attributeSet = this.createAttributeSet(service);
        this.serviceName = service.getName();
        this.setConfiguration(configuration);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = (ConfigurationImpl)configuration;
    }

    private HashSet<String> createAttributeSet(Service service) {
        List<ServiceAttribute> attributeList = service.getAttributeList();
        HashSet<String> set = new HashSet<String>();
        for (ServiceAttribute attribute : attributeList) {
            set.add(attribute.getValue());
        }
        return set;
    }

    @Override
    public Object getAttribute(String attribute_name) throws AttributeNotFoundException {
        if (this.validAttribute(attribute_name)) {
            return this.configuration.getValue(attribute_name);
        }
        throw new AttributeNotFoundException("Cannot find " + attribute_name + " attribute in " + this.serviceName);
    }

    private boolean validAttribute(String attribute_name) {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeAggregatorFactory serviceName cannot be null"), "Cannot invoke a getter of " + this.serviceName + " with null attribute name");
        }
        return this.attributeSet.contains(attribute_name);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mBeanInfo == null) {
            this.createMBeanInfo();
        }
        return this.mBeanInfo;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (!this.validAttribute(name)) {
            throw new AttributeNotFoundException("Attribute " + name + " not found");
        }
        this.setStringAttribute(name, value);
    }

    private void setStringAttribute(String name, Object value) throws InvalidAttributeValueException {
        if (!this.isStringAssignable(value)) {
            throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
        }
        this.setInConfiguration(name, value);
    }

    private void setInConfiguration(String name, Object value) throws InvalidAttributeValueException {
        try {
            this.configuration.setValue(name, (String)value);
        }
        catch (CCLConfigurationException e) {
            throw new InvalidAttributeValueException("Cannot set attribute " + name + " to " + value);
        }
    }

    private boolean isStringAssignable(Object value) {
        try {
            return Class.forName("java.lang.String").isAssignableFrom(value.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            return null;
        }
        AttributeList resultList = new AttributeList();
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                if (!this.validAttribute(attributeNames[i])) continue;
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                cat.debug("Exception while getting attribute ignored ", (Throwable)e);
            }
        }
        return resultList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            return null;
        }
        AttributeList resultList = new AttributeList();
        for (Attribute attr : attributes) {
            String name = attr.getName();
            if (!this.validAttribute(name)) continue;
            try {
                this.setInConfiguration(name, attr.getValue());
                resultList.add(new Attribute(name, this.configuration.getValue(name)));
            }
            catch (JMException e) {
                cat.debug("Exception in Setting attribute ", (Throwable)e);
            }
        }
        return resultList;
    }

    @Override
    public Object invoke(String operationName, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        if (operationName != null) {
            if (operationName.equals("reconfigure")) {
                this.service.reconfigure(this.configuration);
            } else if (operationName.equals("suspend")) {
                this.service.suspend(this.getImmediateParam(params));
            } else if (operationName.equals("resume")) {
                this.service.resume();
            } else {
                throw new MBeanException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.serviceName);
            }
        }
        return null;
    }

    private boolean getImmediateParam(Object[] params) {
        if (params.length != 1) {
            throw new IllegalArgumentException("Invalid number of arguments");
        }
        return (Boolean)params[0];
    }

    private void createMBeanInfo() {
        MBeanAttributeInfo[] attributeInfo = this.createAttributeInfo();
        MBeanOperationInfo[] dOperations = this.createOperationInfo();
        this.mBeanInfo = new MBeanInfo(this.serviceName, "Simple implementation of a dynamic MBean.", attributeInfo, null, dOperations, new MBeanNotificationInfo[0]);
    }

    private MBeanOperationInfo[] createOperationInfo() {
        MBeanOperationInfo[] operationinfo = new MBeanOperationInfo[3];
        operationinfo[0] = new MBeanOperationInfo("reconfigure", "reconfigure(): reconfigure this service", null, "void", 1);
        MBeanParameterInfo[] signature = new MBeanParameterInfo[]{new MBeanParameterInfo("immediate", "boolean", "immediate")};
        operationinfo[1] = new MBeanOperationInfo("suspend", "stop this service", signature, "void", 1);
        operationinfo[2] = new MBeanOperationInfo("resume", "restart this service", null, "void", 1);
        return operationinfo;
    }

    private MBeanAttributeInfo[] createAttributeInfo() {
        MBeanAttributeInfo[] attributeInfo = new MBeanAttributeInfo[this.attributeSet.size()];
        int i = 0;
        for (String attrName : this.attributeSet) {
            attributeInfo[i++] = new MBeanAttributeInfo(attrName, "java.lang.String", attrName, true, true, false);
        }
        return attributeInfo;
    }
}

