/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DispatcherServerGroup {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DispatcherServerGroup.class.getName());
    private static final String SYSTEM = "System";
    private static final String DEFAULT_SERVER_GROUP = "DefaultServerGroup";
    private HashMap<String, JMXDispatcherList> serverGroupMap = new HashMap();
    private HashMap<String, JMXDispatcher> allDispatchers = new HashMap();
    private ExecutorService execService = Executors.newCachedThreadPool();

    public DispatcherServerGroup(DispatcherList dispatcherList) {
        this.createGroups(dispatcherList);
    }

    DispatcherServerGroup() {
    }

    private void createGroups(DispatcherList dispatcherList) {
        this.createSystemGroup(dispatcherList);
        Collection<String> serverGroups = dispatcherList.getCompleteServerGroups();
        for (String group : serverGroups) {
            Collection<DispatcherListElement> dispatcherListElements = dispatcherList.getAllDispatcherListElements(group);
            if (group.equals("")) {
                group = DEFAULT_SERVER_GROUP;
            }
            for (DispatcherListElement element : dispatcherListElements) {
                JMXDispatcher jmxDispatcher = this.allDispatchers.get(element.toString());
                if (jmxDispatcher == null) continue;
                this.addDispatcherToGroup(group, jmxDispatcher);
            }
        }
        this.createHostGroups();
    }

    private void createSystemGroup(DispatcherList dispatcherList) {
        for (DispatcherListElement element : dispatcherList.getCompleteDispatcherListElements()) {
            JMXDispatcher jmxDispatcher = new JMXDispatcher(element);
            this.allDispatchers.put(jmxDispatcher.getName(), jmxDispatcher);
            this.addDispatcherToGroup(SYSTEM, jmxDispatcher);
        }
    }

    public void addDispatcherToGroup(String group, JMXDispatcher jmxDispatcher) {
        JMXDispatcherList dispatcherList = this.serverGroupMap.get(group);
        if (dispatcherList == null) {
            dispatcherList = new JMXDispatcherList();
            this.serverGroupMap.put(group, dispatcherList);
        }
        dispatcherList.add(jmxDispatcher);
    }

    public JMXDispatcherList getDispatchersForGroup(String serverGroup) {
        JMXDispatcherList dispatcherList = this.serverGroupMap.get(serverGroup);
        if (dispatcherList == null) {
            return new JMXDispatcherList();
        }
        return dispatcherList;
    }

    public JMXDispatcherList getAllDispatchers() {
        return this.getDispatchersForGroup(SYSTEM);
    }

    public Set<String> getServerGroups() {
        return this.serverGroupMap.keySet();
    }

    private void createHostGroups() {
        for (JMXDispatcher jmxDispatcher : this.allDispatchers.values()) {
            NodeID nodeID = NodeID.getNodeID(jmxDispatcher.getName());
            if (nodeID == null) continue;
            this.addDispatcherToGroup(nodeID.getHost(), jmxDispatcher);
        }
    }

    public JMXDispatcher verifyDispatcher(String dispatcher) {
        return this.allDispatchers.get(dispatcher);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DispatcherServerGroup) {
            DispatcherServerGroup other = (DispatcherServerGroup)obj;
            if (this.allDispatchers.keySet().equals(other.allDispatchers.keySet()) && this.sameAvailability(other.allDispatchers)) {
                return this.equalsServerGroupMap(other.serverGroupMap);
            }
        }
        return false;
    }

    private boolean sameAvailability(HashMap<?, ?> otherDispatchers) {
        for (Map.Entry<String, JMXDispatcher> entry : this.allDispatchers.entrySet()) {
            JMXDispatcher otherDisp;
            JMXDispatcher disp = entry.getValue();
            if (disp.equals(otherDisp = (JMXDispatcher)otherDispatchers.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        Iterator<String> iterator = this.allDispatchers.keySet().iterator();
        while (iterator.hasNext()) {
            hash += iterator.next().hashCode();
        }
        return hash;
    }

    private boolean equalsServerGroupMap(HashMap<?, ?> map) {
        if (this.serverGroupMap.keySet().equals(map.keySet())) {
            for (String serverGroup : this.serverGroupMap.keySet()) {
                JMXDispatcherList otherDispatchers;
                JMXDispatcherList dispatchers = this.serverGroupMap.get(serverGroup);
                if (dispatchers.equals(otherDispatchers = (JMXDispatcherList)map.get(serverGroup))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JMXDispatcherList getNewDispatcher(DispatcherServerGroup oldDispatcherServerGroups) {
        JMXDispatcherList list = new JMXDispatcherList();
        for (String name : this.allDispatchers.keySet()) {
            JMXDispatcher newDisp = this.allDispatchers.get(name);
            JMXDispatcher oldDisp = oldDispatcherServerGroups.verifyDispatcher(name);
            if (oldDisp != null && newDisp.equals(oldDisp)) continue;
            list.add(newDisp);
        }
        return list;
    }

    public List<String> getNewServerGroups(DispatcherServerGroup oldDispatcherServerGroups) {
        ArrayList<String> newGroups = new ArrayList<String>();
        for (String newGroup : this.serverGroupMap.keySet()) {
            if (oldDispatcherServerGroups.serverGroupMap.get(newGroup) != null) continue;
            newGroups.add(newGroup);
        }
        return newGroups;
    }

    public void checkDispatcherAvailability() {
        this.checkDispatcherAvailability(this.allDispatchers);
    }

    public void checkDispatcherAvailability(HashMap<String, JMXDispatcher> dispatcherList) {
        if (Boolean.getBoolean("com.ibm.cognos.pogo.checkJmxSequentially")) {
            this.checkDispatcherAvailabilitySequentially(dispatcherList);
        } else {
            this.checkDispatcherAvailabilityParallel(this.allDispatchers);
        }
    }

    private void checkDispatcherAvailabilitySequentially(HashMap<String, JMXDispatcher> dispatcherList) {
        for (JMXDispatcher jmxDispatcher : dispatcherList.values()) {
            this.checkAvailability(jmxDispatcher);
        }
    }

    private void checkDispatcherAvailabilityParallel(HashMap<String, JMXDispatcher> dispatcherList) {
        ArrayList<1> tasks = new ArrayList<1>();
        for (final JMXDispatcher jmxDispatcher : dispatcherList.values()) {
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    DispatcherServerGroup.this.checkAvailability(jmxDispatcher);
                    return null;
                }
            });
        }
        try {
            this.execService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            cat.info("Exception while checking dispatcher availability", (Throwable)e);
        }
    }

    private void checkAvailability(JMXDispatcher jmxDispatcher) {
        try {
            if (!jmxDispatcher.canConnect()) {
                jmxDispatcher.setAvailable(false);
            } else {
                jmxDispatcher.setAvailable(true);
            }
        }
        catch (Exception e) {
            jmxDispatcher.setAvailable(false);
            cat.info("Exception while checking dispatcher availability, " + jmxDispatcher.getName(), (Throwable)e);
        }
    }

    public JMXDispatcherList getCompleteJMXDispatcherList() {
        return new JMXDispatcherList(this.allDispatchers);
    }
}

