/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.CounterMbeanInterface;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.monitoring.jmx.MetricNotificationSupport;
import com.cognos.pogo.monitoring.jmx.RequestMetricsNoCompositeMBean;
import java.util.Date;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RequestMetricsNoComposite
extends MetricNotificationSupport
implements RequestMetricsNoCompositeMBean,
CounterMbeanInterface {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor("METRICS." + RequestMetricsNoComposite.class.getName());
    private String name;
    private Date lastResetTime = new Date();
    private String operationalStatus = ServiceStatus.UNKNOWN;
    private Date operationalStatusLastUpdateTime = new Date();
    private long numberOfReceivedRequests = 0L;
    private Date receivedRequestsLastUpdateTime = new Date();
    private long serviceTimeAllRequests = 0L;
    private Date allRequestsLastUpdateTime = new Date();
    private long numberOfSuccessfulRequests = 0L;
    private long serviceTimeSuccessfulRequests = 0L;
    private Date successfulRequestsLastUpdateTime = new Date();
    private long numberOfFailedRequests = 0L;
    private long serviceTimeFailedRequests = 0L;
    private Date failedRequestsLastUpdateTime = new Date();
    private long responseTimeHighWaterMark = 0L;
    private Date responseTimeHighWaterMarkLastUpdateTime = new Date();
    private long responseTimeLowWaterMark = Long.MAX_VALUE;
    private Date responseTimeLowWaterMarkLastUpdateTime = new Date();
    protected long lastResponseTime = 0L;
    protected Date lastResponseTimeLastUpdateTime = new Date();
    private final String service;

    public RequestMetricsNoComposite(String name, String service) {
        this.name = name;
        this.service = service;
    }

    @Override
    public void reset() {
        if (cat.isDebugEnabled()) {
            cat.debug("reset request service=" + this.service);
        }
        this.sendResetNotifications();
        this.numberOfReceivedRequests = 0L;
        this.setReceivedRequestsLastUpdateTime();
        this.serviceTimeAllRequests = 0L;
        this.setAllRequestsLastUpdateTime();
        this.numberOfSuccessfulRequests = 0L;
        this.serviceTimeSuccessfulRequests = 0L;
        this.setSuccessfulRequestsLastUpdateTime();
        this.numberOfFailedRequests = 0L;
        this.serviceTimeFailedRequests = 0L;
        this.setFailedRequestsLastUpdateTime();
        this.responseTimeHighWaterMark = 0L;
        this.setResponseTimeHighWaterMarkLastUpdateTime();
        this.responseTimeLowWaterMark = Long.MAX_VALUE;
        this.setResponseTimeLowWaterMarkLastUpdateTime();
        this.setLastResetTime();
    }

    private void sendResetNotifications() {
        this.sendAttributeChangedNotification("NumberOfReceivedRequests", this.numberOfReceivedRequests, 0L);
        this.sendAttributeChangedNotification("ServiceTimeFailedRequests", this.serviceTimeFailedRequests, 0L);
        this.sendAttributeChangedNotification("NumberOfFailedRequests", this.numberOfFailedRequests, 0L);
        this.sendAttributeChangedNotification("ServiceTimeSuccessfulRequests", this.serviceTimeSuccessfulRequests, 0L);
        this.sendAttributeChangedNotification("NumberOfSuccessfulRequests", this.numberOfSuccessfulRequests, 0L);
        this.sendAttributeChangedNotification("ResponseTimeHighWaterMark", this.responseTimeHighWaterMark, 0L);
        this.sendAttributeChangedNotification("ResponseTimeLowWaterMark", this.responseTimeLowWaterMark, 0L);
        this.sendAttributeChangedNotification("ServiceTimeAllRequests", this.serviceTimeAllRequests, 0L);
        this.sendAttributeChangedNotification("LastResponseTime", this.lastResponseTime, 0L);
    }

    @Override
    public Date getLastRequestResetTime() {
        return this.lastResetTime;
    }

    @Override
    public Date getCurrentTime() {
        return new Date();
    }

    @Override
    public String getOperationalStatus() {
        return this.operationalStatus;
    }

    @Override
    public Date getOperationalStatusLastUpdateTime() {
        return this.operationalStatusLastUpdateTime;
    }

    @Override
    public long getNumberOfReceivedRequests() {
        return this.numberOfReceivedRequests;
    }

    @Override
    public Date getReceivedRequestsLastUpdateTime() {
        return this.receivedRequestsLastUpdateTime;
    }

    @Override
    public long getServiceTimeAllRequests() {
        return this.serviceTimeAllRequests;
    }

    @Override
    public Date getAllRequestsLastUpdateTime() {
        return this.allRequestsLastUpdateTime;
    }

    @Override
    public long getNumberOfSuccessfulRequests() {
        return this.numberOfSuccessfulRequests;
    }

    @Override
    public long getServiceTimeSuccessfulRequests() {
        return this.serviceTimeSuccessfulRequests;
    }

    @Override
    public Date getSuccessfulRequestsLastUpdateTime() {
        return this.successfulRequestsLastUpdateTime;
    }

    @Override
    public long getNumberOfFailedRequests() {
        return this.numberOfFailedRequests;
    }

    @Override
    public long getServiceTimeFailedRequests() {
        return this.serviceTimeFailedRequests;
    }

    @Override
    public Date getFailedRequestsLastUpdateTime() {
        return this.failedRequestsLastUpdateTime;
    }

    @Override
    public long getResponseTimeHighWaterMark() {
        return this.responseTimeHighWaterMark;
    }

    @Override
    public Date getResponseTimeHighWaterMarkLastUpdateTime() {
        return this.responseTimeHighWaterMarkLastUpdateTime;
    }

    @Override
    public long getResponseTimeLowWaterMark() {
        if (this.responseTimeLowWaterMark == Long.MAX_VALUE) {
            return 0L;
        }
        return this.responseTimeLowWaterMark;
    }

    @Override
    public Date getResponseTimeLowWaterMarkLastUpdateTime() {
        return this.responseTimeLowWaterMarkLastUpdateTime;
    }

    @Override
    public long getLastResponseTime() {
        return this.lastResponseTime;
    }

    @Override
    public Date getLastResponseTimeLastUpdateTime() {
        return this.lastResponseTimeLastUpdateTime;
    }

    public void setOperationalStatus(String status) {
        if (!this.operationalStatus.equals(status)) {
            if (cat.isDebugEnabled()) {
                cat.debug("operationalStatus service=" + this.service + " status=" + status);
            }
            String oldOperationalStaus = this.operationalStatus;
            this.operationalStatus = status;
            this.setOperationalStatusLastUpdateTime();
            this.sendOperationalStatusChangeNotification(oldOperationalStaus, status);
        }
    }

    public void setServiceTimeFailedRequests(long serviceTime) {
        if (cat.isDebugEnabled()) {
            cat.debug("failedRequest service=" + this.service + " time=" + serviceTime);
        }
        long old = this.serviceTimeFailedRequests;
        this.serviceTimeFailedRequests += serviceTime;
        ++this.numberOfFailedRequests;
        this.setFailedRequestsLastUpdateTime();
        this.setHighLowLast(serviceTime);
        this.sendAttributeChangedNotification("ServiceTimeFailedRequests", old, this.serviceTimeFailedRequests);
        this.sendAttributeChangedNotification("NumberOfFailedRequests", this.numberOfFailedRequests - 1L, this.numberOfFailedRequests);
    }

    public void setServiceTimeSuccessfulRequests(long serviceTime) {
        if (cat.isDebugEnabled()) {
            cat.debug("successfulRequest service=" + this.service + " time=" + serviceTime);
        }
        long old = this.serviceTimeSuccessfulRequests;
        this.serviceTimeSuccessfulRequests += serviceTime;
        ++this.numberOfSuccessfulRequests;
        this.setSuccessfulRequestsLastUpdateTime();
        this.setHighLowLast(serviceTime);
        this.sendAttributeChangedNotification("ServiceTimeSuccessfulRequests", old, this.serviceTimeSuccessfulRequests);
        this.sendAttributeChangedNotification("NumberOfSuccessfulRequests", this.numberOfSuccessfulRequests - 1L, this.numberOfSuccessfulRequests);
    }

    private void setHighLowLast(long serviceTime) {
        long oldAll = this.serviceTimeAllRequests;
        this.serviceTimeAllRequests += serviceTime;
        this.setAllRequestsLastUpdateTime();
        long oldLast = this.lastResponseTime;
        this.lastResponseTime = serviceTime;
        this.setLastResponseTimeLastUpdateTime();
        if (serviceTime > this.responseTimeHighWaterMark) {
            long oldHigh = this.responseTimeHighWaterMark;
            this.responseTimeHighWaterMark = serviceTime;
            this.setResponseTimeHighWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("ResponseTimeHighWaterMark", oldHigh, this.responseTimeHighWaterMark);
        }
        if (serviceTime < this.responseTimeLowWaterMark) {
            long oldLow = this.responseTimeLowWaterMark;
            this.responseTimeLowWaterMark = serviceTime;
            this.setResponseTimeLowWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("ResponseTimeLowWaterMark", oldLow, this.responseTimeLowWaterMark);
        }
        this.sendAttributeChangedNotification("ServiceTimeAllRequests", oldAll, this.serviceTimeAllRequests);
        this.sendAttributeChangedNotification("LastResponseTime", oldLast, this.lastResponseTime);
    }

    public void setAllRequestsLastUpdateTime() {
        this.allRequestsLastUpdateTime.setTime(System.currentTimeMillis());
    }

    public void setFailedRequestsLastUpdateTime() {
        this.failedRequestsLastUpdateTime.setTime(System.currentTimeMillis());
    }

    public void setLastResetTime() {
        this.lastResetTime.setTime(System.currentTimeMillis());
    }

    public void setLastResponseTimeLastUpdateTime() {
        this.lastResponseTimeLastUpdateTime.setTime(System.currentTimeMillis());
    }

    public void setOperationalStatusLastUpdateTime() {
        this.operationalStatusLastUpdateTime.setTime(System.currentTimeMillis());
    }

    public void setReceivedRequestsLastUpdateTime() {
        this.receivedRequestsLastUpdateTime.setTime(System.currentTimeMillis());
    }

    public void setResponseTimeHighWaterMarkLastUpdateTime() {
        this.responseTimeHighWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    public void setResponseTimeLowWaterMarkLastUpdateTime() {
        this.responseTimeLowWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    public void setSuccessfulRequestsLastUpdateTime() {
        this.successfulRequestsLastUpdateTime.setTime(System.currentTimeMillis());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void incrementNumberOfReceivedRequests() {
        if (cat.isDebugEnabled()) {
            cat.debug("recievedRequest service=" + this.service);
        }
        ++this.numberOfReceivedRequests;
        this.setReceivedRequestsLastUpdateTime();
        this.sendAttributeChangedNotification("NumberOfReceivedRequests", this.numberOfReceivedRequests - 1L, this.numberOfReceivedRequests);
    }
}

