/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.jmx.aggregator.AttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.HealthAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.LastAttributeAggregator;
import com.cognos.pogo.monitoring.jmx.aggregator.OperationalStatusAttributeAggregator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ServiceHealth
implements DynamicMBean {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ServiceHealth.class.getName());
    protected HashMap<String, DynamicMBean> serviceHealthHashMap;
    private MBeanInfo mBeanInfo;
    private final String attributeName;

    public ServiceHealth(HashMap<String, DynamicMBean> serviceHealthHashMap, String attributeName) {
        this.serviceHealthHashMap = serviceHealthHashMap;
        this.attributeName = attributeName;
    }

    public ServiceHealth(HashMap<String, DynamicMBean> serviceHealthHashMap) {
        this(serviceHealthHashMap, "Health");
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute.equals(this.attributeName)) {
            return this.consolidatedHealth();
        }
        DynamicMBean serviceMBean = this.serviceHealthHashMap.get(attribute);
        if (serviceMBean == null) {
            throw new AttributeNotFoundException();
        }
        try {
            return serviceMBean.getAttribute(this.attributeName);
        }
        catch (AttributeNotFoundException anfe) {
            throw anfe;
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes.length == 1 && attributes[0].equals("*")) {
            return this.fullServiceList();
        }
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                attrList.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attrList;
    }

    private AttributeList fullServiceList() {
        AttributeList attrList = new AttributeList();
        AttributeAggregator aggregator = this.getAttributeAggregator();
        for (String serviceName : this.serviceHealthHashMap.keySet()) {
            DynamicMBean serviceMBean = this.serviceHealthHashMap.get(serviceName);
            try {
                String health = (String)serviceMBean.getAttribute(this.attributeName);
                aggregator.combine(health);
                attrList.add(new Attribute(serviceName, health));
            }
            catch (AttributeNotFoundException health) {
            }
            catch (MBeanException e) {
                cat.error("catch", (Throwable)e);
            }
            catch (ReflectionException e) {
                cat.error("catch", (Throwable)e);
            }
        }
        attrList.add(new Attribute(this.attributeName, aggregator.getAggregation()));
        return attrList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mBeanInfo == null) {
            this.mBeanInfo = this.createMBeanInfo();
        }
        return this.mBeanInfo;
    }

    private MBeanInfo createMBeanInfo() {
        ArrayList<MBeanAttributeInfo> mBeanAttributeInfo = this.createMBeanAttributeInfoList();
        mBeanAttributeInfo.add(this.createMBeanAttributeInfo(this.attributeName));
        MBeanAttributeInfo[] attrInfo = mBeanAttributeInfo.toArray(new MBeanAttributeInfo[mBeanAttributeInfo.size()]);
        return new MBeanInfo(this.getClass().getName(), "description", attrInfo, null, null, null);
    }

    private ArrayList<MBeanAttributeInfo> createMBeanAttributeInfoList() {
        ArrayList<MBeanAttributeInfo> mBeanAttributeInfoList = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<String, DynamicMBean> entry : this.serviceHealthHashMap.entrySet()) {
            this.addMBeanToList(mBeanAttributeInfoList, entry);
        }
        return mBeanAttributeInfoList;
    }

    private void addMBeanToList(ArrayList<MBeanAttributeInfo> mBeanAttributeInfoList, Map.Entry<String, DynamicMBean> entry) {
        DynamicMBean mBean = entry.getValue();
        if (this.checkMBeanHasAttribute(mBean)) {
            String attrName = entry.getKey();
            mBeanAttributeInfoList.add(this.createMBeanAttributeInfo(attrName));
        }
    }

    private MBeanAttributeInfo createMBeanAttributeInfo(String attrName) {
        return new MBeanAttributeInfo(attrName, "java.lang.String", attrName, true, false, false);
    }

    private boolean checkMBeanHasAttribute(DynamicMBean mBean) {
        MBeanAttributeInfo[] beanAttributeInfos;
        MBeanInfo beanInfo = mBean.getMBeanInfo();
        for (MBeanAttributeInfo mBeanAttributeInfo : beanAttributeInfos = beanInfo.getAttributes()) {
            if (!mBeanAttributeInfo.getName().equals(this.attributeName)) continue;
            return true;
        }
        return false;
    }

    private Object consolidatedHealth() {
        AttributeAggregator aggregator = this.getAttributeAggregator();
        for (DynamicMBean mBean : this.serviceHealthHashMap.values()) {
            try {
                aggregator.combine(mBean.getAttribute(this.attributeName));
            }
            catch (Exception exception) {}
        }
        return aggregator.getAggregation();
    }

    private AttributeAggregator getAttributeAggregator() {
        AttributeAggregator aggregator = this.attributeName.equals("Health") ? new HealthAttributeAggregator() : (this.attributeName.equals("OperationalStatus") ? new OperationalStatusAttributeAggregator() : new LastAttributeAggregator());
        return aggregator;
    }
}

