/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.handlers.engine.PropagateStatus;
import com.cognos.pogo.handlers.engine.PropagateStatusGlobal;
import com.cognos.pogo.monitoring.jmx.LocalMBeanHookup;
import com.cognos.pogo.monitoring.jmx.remote.proxy.ActiveProxyNotifier;
import com.cognos.pogo.monitoring.jmx.remote.proxy.ProxyConfiguration;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManager;
import com.cognos.pogo.monitoring.jmx.threshold.ThresholdManagerFactory;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;

public class TotalHandler
extends BasicHandler {
    private static final int PROXY_NOTIFY_TIMEOUT = 5000;
    protected static final PogoLogger cat = PogoLogger.getLogger();
    private String localSearchPath;
    private final LocalMBeanHookup localMBeanHookup;
    private String proxyJmxUrl;
    private ActiveProxyNotifier activeProxyNotifier;
    private PropagateStatus propagateStatus;

    public TotalHandler() {
        this(new LocalMBeanHookup(), new ActiveProxyNotifier());
    }

    public TotalHandler(LocalMBeanHookup localMBeanHookup, ActiveProxyNotifier activeProxyNotifier) {
        super(cat.getNativeLogger());
        this.localMBeanHookup = localMBeanHookup;
        this.activeProxyNotifier = activeProxyNotifier;
        this.propagateStatus = new PropagateStatusGlobal();
    }

    @Override
    public void configure(Configuration configuration) {
        this.localSearchPath = configuration.getLocalSearchPath();
        this.proxyJmxUrl = ProxyConfiguration.getActiveJMXProxyURI(configuration);
        this.propagateStatus.configure(configuration);
    }

    @Override
    public void start() {
        this.start(this.localSearchPath);
        this.propagateStatusToAllDispatchers();
    }

    private void propagateStatusToAllDispatchers() {
        this.propagateStatus.propagateStatus();
    }

    void start(String searchPath) {
        ThresholdManager thresholdManager = ThresholdManagerFactory.getThresholdManager();
        this.localMBeanHookup.finishLocalDispatcher(searchPath, thresholdManager);
        SafeThread thread = this.activeProxyNotifier.notifyActiveProxy(this.proxyJmxUrl);
        try {
            thread.join(5000L);
        }
        catch (InterruptedException e) {
            cat.debug("Notify active proxy timed out. Continue anyway", e);
        }
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    public void setProxyJmxUrlForTesting(String proxyJmxUrl) {
        this.proxyJmxUrl = proxyJmxUrl;
    }
}

