/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.aggregator;

import com.cognos.pogo.monitoring.OperationalStatus;
import com.cognos.pogo.monitoring.jmx.aggregator.AttributeAggregator;
import com.cognos.pogo.util.PogoLogger;

public class OperationalStatusAttributeAggregator
implements AttributeAggregator {
    private static final PogoLogger log = PogoLogger.getLogger();
    private OperationalStatus currentOperationalStatus = OperationalStatus.unknown;

    @Override
    public void combine(Object attributeValue) {
        OperationalStatus serviceStatus = OperationalStatus.safeValueOf(attributeValue);
        OperationalStatus newOperationalStatus = this.currentOperationalStatus.aggregate(serviceStatus);
        this.logStatusChange(newOperationalStatus, serviceStatus);
        this.currentOperationalStatus = newOperationalStatus;
    }

    private void logStatusChange(OperationalStatus newOperationalStatus, OperationalStatus serviceStatus) {
        if (!this.currentOperationalStatus.equals((Object)newOperationalStatus)) {
            log.debug(new Object[]{this, " changing operational status from ", this.currentOperationalStatus, " to ", newOperationalStatus, " after service status ", serviceStatus});
        }
    }

    @Override
    public Object getAggregation() {
        return this.currentOperationalStatus.toString();
    }
}

