/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpConfig;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpControlHandler;
import com.cognos.pogo.monitoring.jmx.dump.MBeanDumpControlMBean;
import com.cognos.pogo.monitoring.jmx.dump.RemoteMBeanDump;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MBeanDumpControl
implements MBeanDumpControlMBean {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(MBeanDumpControlHandler.class.getName());
    private RemoteMBeanDump beanDump = new RemoteMBeanDump();
    private MBeanDumpConfig mBeanDumpConfig = new MBeanDumpConfig();
    private long currentInterval;
    private Timer timer;
    private boolean enabled = false;
    private long currentIteration = 0L;
    private String enabledDispatcher;

    public void reconfigure(MBeanDumpConfig newMBeanDumpConfig) {
        this.mBeanDumpConfig = newMBeanDumpConfig;
        long interval = this.mBeanDumpConfig.getInterval();
        this.setInterval(interval);
    }

    @Override
    public void setInterval(long interval) {
        if (this.currentInterval != interval) {
            this.currentInterval = interval;
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.startTimer(this.currentInterval);
        }
    }

    public void startTimer(long interval) {
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new MBeanDumpTimerTask(), interval, interval);
    }

    @Override
    public void dump() {
        long limitCount = this.mBeanDumpConfig.getLimitCount();
        if (this.enabled && (limitCount == -1L || this.currentIteration < limitCount)) {
            cat.debug("performing dump");
            this.beanDump.setFilename(this.mBeanDumpConfig.getFilename());
            this.beanDump.setMaxFilesize(this.mBeanDumpConfig.getLimitSize());
            this.beanDump.setMBeanNames(this.mBeanDumpConfig.getMbeans());
            this.beanDump.setRolloverLimit(this.mBeanDumpConfig.getLimitRollover());
            this.beanDump.setResetAfterDump(this.mBeanDumpConfig.getResetAfterDump());
            this.beanDump.dump();
            ++this.currentIteration;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (!wasEnabled && enabled) {
            this.currentIteration = 0L;
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public String getFilename() {
        return this.mBeanDumpConfig.getFilename();
    }

    @Override
    public void setFilename(String filename) {
        this.mBeanDumpConfig.setFilename(filename);
    }

    @Override
    public long getMaxFilesize() {
        return this.mBeanDumpConfig.getLimitSize();
    }

    @Override
    public void setMaxFilesize(long limitSize) {
        this.mBeanDumpConfig.setLimitSize(limitSize);
    }

    @Override
    public long getRolloverLimit() {
        return this.mBeanDumpConfig.getLimitRollover();
    }

    @Override
    public void setRolloverLimit(long limitRollover) {
        this.mBeanDumpConfig.setLimitRollover(limitRollover);
    }

    @Override
    public String[] getMBeanNames() {
        return this.mBeanDumpConfig.getMbeans();
    }

    @Override
    public void setMBeanNames(String[] names) {
        this.mBeanDumpConfig.setMbeans(names);
    }

    @Override
    public long getIterationLimit() {
        return this.mBeanDumpConfig.getLimitCount();
    }

    @Override
    public void setIterationLimit(long limit) {
        this.mBeanDumpConfig.setLimitCount(limit);
    }

    @Override
    public long getCurrentIteration() {
        return this.currentIteration;
    }

    @Override
    public long getInterval() {
        return this.currentInterval;
    }

    public void setEnabledDispatcher(String enabledDispatcher) {
        this.enabledDispatcher = enabledDispatcher;
    }

    @Override
    public String getEnabledDispatcher() {
        return this.enabledDispatcher;
    }

    public class MBeanDumpTimerTask
    extends SafeTimerTask {
        @Override
        public void safeRun() {
            MBeanDumpControl.this.dump();
        }
    }
}

