/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.dump;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.MBeanUtils;
import java.io.IOException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RemoteMBeanDump {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RemoteMBeanDump.class.getName());
    private static final String DUMP_MBEAN_NAME = MBeanUtils.buildObjectName("type=MBeanDump,*");
    private static final String DUMP_METHOD = "dump";
    private MBeanServerConnection mbeanServerConnection;
    private String filename;
    private Long maxFilesize;
    private String[] mbeanNames;
    private Long rolloverLimit;
    private Boolean resetAfterDump;

    public RemoteMBeanDump() {
    }

    public RemoteMBeanDump(MBeanServerConnection connection) {
        this.mbeanServerConnection = connection;
    }

    public void dump() {
        try {
            Set<ObjectName> objectNameList = this.getMbeanServerConnection().queryNames(ObjectName.getInstance(DUMP_MBEAN_NAME), null);
            for (ObjectName objectName : objectNameList) {
                this.reconfigureDumping(objectName);
                this.getMbeanServerConnection().invoke(objectName, DUMP_METHOD, null, null);
            }
        }
        catch (MalformedObjectNameException e) {
            cat.error("catch", (Throwable)e);
        }
        catch (JMException e) {
            cat.error("Exception in RemoteMBeanDump", (Throwable)e);
        }
        catch (IOException e) {
            cat.error("Exception in RemoteMBeanDump", (Throwable)e);
        }
    }

    private void reconfigureDumping(ObjectName objectName) throws JMException, IOException {
        AttributeList attributes = new AttributeList();
        attributes.add(new Attribute("Filename", this.filename));
        attributes.add(new Attribute("MaxFilesize", this.maxFilesize));
        attributes.add(new Attribute("MBeanNames", this.mbeanNames));
        attributes.add(new Attribute("RolloverLimit", this.rolloverLimit));
        attributes.add(new Attribute("ResetAfterDump", this.resetAfterDump));
        this.getMbeanServerConnection().setAttributes(objectName, attributes);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setMaxFilesize(Long maxFilesize) {
        this.maxFilesize = maxFilesize;
    }

    public void setMaxFilesize(long maxFilesize) {
        this.maxFilesize = new Long(maxFilesize);
    }

    public void setMBeanNames(String[] mbeanNames) {
        this.mbeanNames = mbeanNames;
    }

    public void setRolloverLimit(Long limitRollover) {
        this.rolloverLimit = limitRollover;
    }

    public void setRolloverLimit(long limitRollover) {
        this.rolloverLimit = new Long(limitRollover);
    }

    public void setResetAfterDump(boolean reset) {
        this.resetAfterDump = reset;
    }

    private MBeanServerConnection getMbeanServerConnection() {
        return this.mbeanServerConnection != null ? this.mbeanServerConnection : PogoMBeanServer.getInstance().getProxyMBeanServer();
    }
}

