/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnection;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnectionFactory;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ActiveProxyNotifier {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String DISPATCHER_PROXY_UPDATER = "com.cognos:type=DispatcherProxyUpdater";
    private JMXDispatcherConnectionFactory jmxDispatcherConnectionFactory;

    public ActiveProxyNotifier() {
        this(new JMXDispatcherConnectionFactory());
    }

    public ActiveProxyNotifier(JMXDispatcherConnectionFactory jmxDispatcherConnectionFactory) {
        this.jmxDispatcherConnectionFactory = jmxDispatcherConnectionFactory;
    }

    public SafeThread notifyActiveProxy(final String proxyJmxUrl) {
        SafeThread safeThread = new SafeThread(){

            @Override
            protected void safeRun() {
                String thisDispatcherName = PropertyInserter.getProperty("dispatcher.name");
                try {
                    MBeanServerConnection proxyMBeanServer = ActiveProxyNotifier.this.getProxyMBeanServer(proxyJmxUrl);
                    if (proxyMBeanServer != null) {
                        log.debug("reconfiguring dispatcher on proxy ", proxyJmxUrl);
                        Object[] args = new Object[]{thisDispatcherName};
                        String[] parameters = new String[]{"java.lang.String"};
                        proxyMBeanServer.invoke(ObjectName.getInstance(ActiveProxyNotifier.DISPATCHER_PROXY_UPDATER), "reconfigureDispatcher", args, parameters);
                    }
                }
                catch (Exception e) {
                    log.debug("Unable to reconfigure dispatcher on proxy", e);
                }
            }
        };
        safeThread.start();
        return safeThread;
    }

    MBeanServerConnection getProxyMBeanServer(String proxyJmxUrl) {
        JMXDispatcherConnection jmxDispatcherConnection = this.jmxDispatcherConnectionFactory.createConnection(proxyJmxUrl);
        jmxDispatcherConnection.connect();
        return jmxDispatcherConnection.getMbeanServerConnection();
    }
}

