/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy;

import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerUpdateCommand;
import com.cognos.pogo.monitoring.jmx.remote.proxy.ProxyConfiguration;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ContentManagerProxyCommand {
    private static final PogoLogger logger = PogoLogger.getLogger();
    private String activJMXProxyURIParam;

    public ContentManagerProxyCommand(Configuration configuration) {
        this(ProxyConfiguration.getActiveJMXProxyURI(configuration));
    }

    public ContentManagerProxyCommand(String activeJMXProxyURI) {
        this.activJMXProxyURIParam = activeJMXProxyURI;
    }

    public void updateCM(String activeProxyName, ContentManagerUpdateCommand command) {
        if (this.activJMXProxyURIParam == null || !this.activJMXProxyURIParam.equals(activeProxyName)) {
            try {
                this.doUpdateCommand(activeProxyName, command);
                this.activJMXProxyURIParam = activeProxyName;
                logger.debug("updateCM() - updated CM with new active proxy '" + activeProxyName + "'.");
            }
            catch (CommandExecutionException e) {
                logger.debug("Trouble while updating in CM ", e);
            }
        }
    }

    public void updateCM(String activeProxyName) {
        this.updateCM(activeProxyName, new ContentManagerUpdateCommand());
    }

    private void doUpdateCommand(String activeProxyName, ContentManagerUpdateCommand update) throws CommandExecutionException {
        update.addObject("configuration");
        update.setSearchPath("/configuration");
        update.addURIItem(QName.get((String)"activeJMXProxyURI", (Namespace)BIBusCommand.BUS_NAMESPACE), activeProxyName);
        update.setDoTrustedRequest(true);
        update.execute();
    }
}

