/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.remote.proxy.chooser;

import com.cognos.pogo.monitoring.jmx.remote.proxy.ContentManagerProxyCommand;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ChooseProxy;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyMonitor;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.ProxyObserver;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;

public class ProxyUpdater
implements ProxyObserver {
    private static PogoLogger log = PogoLogger.getLogger();
    private ProxyMonitor proxyMonitor;
    private ContentManagerProxyCommand contentManagerProxyCommand;

    public ProxyUpdater(Configuration configuration) {
        this(new ProxyMonitor(), configuration);
    }

    public ProxyUpdater(ProxyMonitor proxyMonitor, Configuration configuration) {
        this(proxyMonitor, new ContentManagerProxyCommand(configuration));
    }

    public ProxyUpdater(ProxyMonitor proxyMonitor, ContentManagerProxyCommand contentManagerProxyCommand) {
        this.proxyMonitor = proxyMonitor;
        this.contentManagerProxyCommand = contentManagerProxyCommand;
        proxyMonitor.addObserver(this);
    }

    public void start(Configuration configuration) {
        log.debug("starting ProxyMonitor from configuration");
        this.proxyMonitor.start(configuration);
    }

    public void start(ChooseProxy chooseProxy) {
        this.proxyMonitor.start(chooseProxy);
    }

    @Override
    public void update(String jmxProxy) {
        this.contentManagerProxyCommand.updateCM(jmxProxy);
        log.debug("update() - update CM with jmx url: " + jmxProxy);
    }

    public void stop() {
        this.proxyMonitor.stop();
    }

    ProxyMonitor getProxyMonitor() {
        return this.proxyMonitor;
    }
}

