/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.CommandExecutor;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import com.cognos.pogo.pdk.common.UserCapabilityCacheException;
import com.cognos.pogo.util.PogoLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class InteractiveReportCancellation
extends BIBusCommand
implements CommandExecutor {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final int DEFAULT_AFFINITY_STRENGTH = 30000;
    private String requestContext;
    private String host;
    private int port;
    private boolean ssl;
    private final String soapAction = "http://developer.cognos.com/schemas/bibus/3#reportService.control";

    public InteractiveReportCancellation(String passportID, String reportID, int processID) {
        this(passportID, reportID, processID, null);
    }

    public InteractiveReportCancellation(String passportIdUserCapabilities, String reportID, int processID, String userCapabilities) {
        NodeID self = NodeID.getSelf();
        this.host = self.getHost();
        this.port = self.getPort();
        this.ssl = self.getProtocol().equals("https");
        this.requestContext = self.getPath();
        String[] passportAndCapabilities = passportIdUserCapabilities.split("#");
        String passportID = passportAndCapabilities[0];
        String userCapability = passportAndCapabilities.length > 1 ? passportAndCapabilities[1] : null;
        this.getRequestEnvelope().createCamPassportElement(passportID);
        this.getRequestEnvelope().setConversationContextID(reportID);
        this.getRequestEnvelope().setConversationContextNodeID(self.getGuid());
        this.getRequestEnvelope().setConversationContextAffinityStrength(30000);
        this.getRequestEnvelope().setConversationContextProcessID(processID);
        this.parseUserCapabilityCache(userCapability);
    }

    private void parseUserCapabilityCache(String userCapabilities) {
        if (userCapabilities != null) {
            try {
                UserCapabilityCache userCapabilityCache = this.getRequestEnvelope().getBiBusHeader().getUserCapabilityCache();
                String decodedCapabilities = URLDecoder.decode(userCapabilities, "UTF-8");
                userCapabilityCache.parseAndStoreCookie(decodedCapabilities);
            }
            catch (UserCapabilityCacheException e) {
                log.debug("Unable to decode user capability cache ", e);
            }
            catch (UnsupportedEncodingException e1) {
                log.debug("Unable to URL decode user capability cache ", e1);
            }
        }
    }

    @Override
    protected void addExtraHTTPHeaders(ServerConnection connection) {
        super.addExtraHTTPHeaders(connection);
        connection.setRequestHeader("SOAPAction", this.getSoapAction());
    }

    @Override
    protected void executeImpl(Element bodyElement) throws CommandExecutionException {
        bodyElement.addElement(this.getCancelQName());
    }

    protected QName getCancelQName() {
        Namespace NS_REPORT_SERVICE = Namespace.get((String)"rs", (String)"http://developer.cognos.com/schemas/reportService/1");
        QName CANCEL = DocumentHelper.createQName((String)"cancel", (Namespace)NS_REPORT_SERVICE);
        return CANCEL;
    }

    @Override
    protected String fetchRequestContext() {
        return this.requestContext;
    }

    @Override
    protected ServerConnection fetchServerConnection() {
        return new StandaloneServerConnection(this.host, this.port, this.ssl);
    }

    @Override
    protected void handleResponseImpl(Element bodyElement) throws CommandExecutionException {
    }

    protected String getSoapAction() {
        return "http://developer.cognos.com/schemas/bibus/3#reportService.control";
    }
}

