/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.CommandExecutor;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.jmx.report.CachedReportData;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportCMQuery;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportCancellationFactory;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportList;
import com.cognos.pogo.reportservice.ReportServerRequestInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class InteractiveReportGeneralList {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(InteractiveReportGeneralList.class.getName());
    public static final String RUNNING = "running";
    public static final String PENDING = "pending";
    private final InteractiveReportList reportList;
    private String listType = "running";
    private InteractiveReportCancellationFactory interactiveReportCancellationFactory;

    public InteractiveReportGeneralList(InteractiveReportList reportList) {
        this(reportList, new InteractiveReportCancellationFactory());
    }

    public InteractiveReportGeneralList(InteractiveReportList reportList, InteractiveReportCancellationFactory interactiveReportCancellationFactory) {
        this.reportList = reportList;
        this.interactiveReportCancellationFactory = interactiveReportCancellationFactory;
    }

    public String getListType() {
        return this.listType;
    }

    public void setListTypePending() {
        this.listType = PENDING;
    }

    public void getShortCompositesFromList(Collection<CompositeData> returnList) {
        for (ReportServerRequestInformation request : this.reportList.getRequests()) {
            this.addCompositeToList(returnList, this.getListType(), null, true, request, null);
        }
    }

    private void addCompositeToList(Collection<CompositeData> returnList, String listType, String contentLocale, boolean isShort, ReportServerRequestInformation request, String passportID) {
        CachedReportData reportData = this.createReportData();
        reportData.getCachedReportData(request, listType);
        try {
            CompositeData data = reportData.getShortCompositeData();
            returnList.add(data);
        }
        catch (OpenDataException ode) {
            cat.error("Exception thrown when formatting report data", (Throwable)ode);
        }
    }

    public long getFullCompositesFromList(List<CompositeData> returnList, List<?> reportIdList, InteractiveReportCMQuery cmQuery, int pageOffset, int pageSize) {
        HashMap<String, ReportServerRequestInformation> reportSet = new HashMap<String, ReportServerRequestInformation>(this.reportList.getRequests().size());
        for (ReportServerRequestInformation req : this.reportList.getRequests()) {
            reportSet.put(req.getRequestID(), req);
        }
        ArrayList<ReportServerRequestInformation> currentReportList = new ArrayList<ReportServerRequestInformation>(returnList.size());
        ListIterator<?> iter = reportIdList.listIterator();
        while (iter.hasNext()) {
            String reportID = (String)iter.next();
            if (!reportSet.containsKey(reportID)) continue;
            currentReportList.add((ReportServerRequestInformation)reportSet.get(reportID));
        }
        int reportsToCheck = pageOffset + pageSize;
        int chunkLength = reportsToCheck;
        for (int chunkStart = 0; returnList.size() < reportsToCheck && chunkStart < currentReportList.size(); chunkStart += chunkLength) {
            this.getReportChunk(cmQuery, returnList, currentReportList, chunkStart, chunkLength, this.getListType());
            chunkLength = pageSize;
        }
        return returnList.size();
    }

    private void getReportChunk(InteractiveReportCMQuery cmQuery, List<CompositeData> returnList, ArrayList<ReportServerRequestInformation> currentReportList, int chunkStart, int chunkLength, String listType) {
        cmQuery.reset();
        for (int r = chunkStart; r < chunkStart + chunkLength && r < currentReportList.size(); ++r) {
            ReportServerRequestInformation request = currentReportList.get(r);
            CachedReportData reportData = this.createReportData();
            reportData.getCachedReportData(request, listType);
            cmQuery.addRequest(reportData);
        }
        try {
            cmQuery.execute(returnList);
        }
        catch (CommandExecutionException e) {
            cat.error("Error getting interactive report details from CM", (Throwable)e);
        }
    }

    public String cancelReport(String reportID, String passportID, String contentLocale) {
        return this.cancelReport(reportID, passportID, contentLocale, null);
    }

    public String cancelReport(String reportID, String passportID, String contentLocale, String userCapabilities) {
        for (ReportServerRequestInformation request : this.reportList.getRequests()) {
            if (!reportID.equals(request.getRequestID())) continue;
            CommandExecutor cancellation = userCapabilities == null ? this.getCancellationCommand(reportID, passportID, request) : this.getCancellationCommand(reportID, passportID, request, userCapabilities);
            if (cancellation == null) {
                cat.debug("cancel report failed - no cancellation command was constructed.  This probably means that the request cannot be cancelled.");
                return this.getStringForLocale("InteractiveReportMonitor.cancelFailed", contentLocale);
            }
            try {
                cancellation.execute();
                return this.getStringForLocale("InteractiveReportMonitor.cancelSuceeded", contentLocale);
            }
            catch (CommandExecutionException e) {
                cat.debug("cancel report failed", (Throwable)e);
                return this.getStringForLocale("InteractiveReportMonitor.cancelFailed", contentLocale);
            }
        }
        return null;
    }

    private String getStringForLocale(String string, String contentLocale) {
        if (contentLocale == null) {
            return DispatcherStrings.getInstance().getString(string);
        }
        return DispatcherStrings.getInstance().getString(string, new Locale(contentLocale));
    }

    protected CachedReportData createReportData() {
        CachedReportData reportData = new CachedReportData();
        return reportData;
    }

    protected CommandExecutor getCancellationCommand(String reportID, String passportID, ReportServerRequestInformation request) {
        return this.interactiveReportCancellationFactory.getInstance(passportID, reportID, request.getProcessID());
    }

    protected CommandExecutor getCancellationCommand(String reportID, String passportID, ReportServerRequestInformation request, String userCapabilities) {
        return this.interactiveReportCancellationFactory.getInstance(passportID, reportID, request.getProcessID(), userCapabilities);
    }

    public boolean typeIsRunning() {
        return RUNNING.equals(this.listType);
    }
}

