/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx.report;

import com.cognos.pogo.monitoring.jmx.report.CountCompositeDataSupport;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportCMQuery;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportGeneralList;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportMonitorMBean;
import java.util.ArrayList;
import java.util.HashSet;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class InteractiveReportMonitor
implements InteractiveReportMonitorMBean {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(InteractiveReportMonitor.class.getName());
    private ArrayList<InteractiveReportGeneralList> reportLists = new ArrayList();
    private CountCompositeDataSupport countCompositeDataSupport = new CountCompositeDataSupport();

    public InteractiveReportMonitor(InteractiveReportGeneralList queuedList, InteractiveReportGeneralList inProgressList) {
        queuedList.setListTypePending();
        this.reportLists.add(queuedList);
        this.reportLists.add(inProgressList);
    }

    @Override
    public CompositeData[] getReports() {
        HashSet<CompositeData> returnList = new HashSet<CompositeData>();
        for (InteractiveReportGeneralList list : this.reportLists) {
            list.getShortCompositesFromList(returnList);
        }
        return returnList.toArray(new CompositeData[returnList.size()]);
    }

    @Override
    public CompositeData[] getDetails(String[] reportIDs, String[] dispatchers, String contentLocale, String passportID) {
        return this.getDetails(reportIDs, dispatchers, contentLocale, 0, reportIDs.length, passportID);
    }

    @Override
    public CompositeData[] getDetails(String[] reportIDs, String[] dispatchers, String contentLocale, int pageOffset, int pageSize, String passportID) {
        return this.getDetails(reportIDs, dispatchers, contentLocale, pageOffset, pageSize, passportID, true);
    }

    @Override
    public CompositeData[] getDetails(String[] reportIDs, String[] dispatchers, String contentLocale, int pageOffset, int pageSize, String passportID, boolean shown) {
        int reportsToCheck = pageOffset + pageSize;
        ArrayList<CompositeData> returnList = new ArrayList<CompositeData>(reportsToCheck + 1);
        int arrayLength = reportIDs.length;
        ArrayList<String> reportIdList = new ArrayList<String>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            reportIdList.add(reportIDs[i]);
        }
        long runningReportsMatched = 0L;
        long queuedReportsMatched = 0L;
        for (InteractiveReportGeneralList list : this.reportLists) {
            InteractiveReportCMQuery cmQuery = this.createCMQuery(contentLocale, passportID, shown);
            long reportsMatched = list.getFullCompositesFromList(returnList, reportIdList, cmQuery, pageOffset, pageSize);
            if (list.typeIsRunning()) {
                runningReportsMatched += reportsMatched;
                continue;
            }
            queuedReportsMatched += reportsMatched;
        }
        returnList.add(0, this.getCounts(runningReportsMatched, queuedReportsMatched));
        return returnList.toArray(new CompositeData[returnList.size()]);
    }

    protected InteractiveReportCMQuery createCMQuery(String contentLocale, String passportID, boolean shown) {
        InteractiveReportCMQuery cmQuery = new InteractiveReportCMQuery(contentLocale, passportID, shown);
        return cmQuery;
    }

    private CompositeData getCounts(long runningReportsMatched, long queuedReportsMatched) {
        try {
            Long[] values = new Long[]{new Long(runningReportsMatched + queuedReportsMatched), new Long(runningReportsMatched), new Long(queuedReportsMatched)};
            return this.countCompositeDataSupport.getCountCompositeData(runningReportsMatched, queuedReportsMatched, runningReportsMatched + queuedReportsMatched);
        }
        catch (OpenDataException e) {
            cat.error("Unable to create InteractiveReport counters", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] cancelReports(String[] reportIDs, String[] dispatchers, String passportID) {
        return this.cancelReports(reportIDs, dispatchers, passportID, null);
    }

    @Override
    public String[] cancelReports(String[] reportIDs, String[] dispatchers, String passportID, String contentLocale) {
        return this.cancelReports(reportIDs, dispatchers, passportID, contentLocale, null);
    }

    public String[] cancelReports(String[] reportIDs, String[] dispatchers, String passportID, String contentLocale, String userCapabilities) {
        String[] results = new String[reportIDs.length];
        for (InteractiveReportGeneralList list : this.reportLists) {
            if (!list.typeIsRunning()) continue;
            for (int i = 0; i < reportIDs.length; ++i) {
                results[i] = list.cancelReport(reportIDs[i], passportID, contentLocale, userCapabilities);
            }
        }
        return results;
    }
}

